/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util.intr.test;

import cytoscape.util.intr.IntEnumerator;
import cytoscape.util.intr.IntHash;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;

public class IntHashPerformance {
    static IntHash _THE_HASHTABLE_ = null;

    public static void main(String[] args) throws Exception {
        int i;
        int read;
        int N = Integer.parseInt(args[0]);
        boolean repeat = false;
        if (args.length > 1 && args[1].equalsIgnoreCase("repeat")) {
            repeat = true;
        }
        int[] elements = new int[N];
        InputStream in = System.in;
        byte[] buff = new byte[4];
        int inx = 0;
        int off = 0;
        while (inx < N && (read = in.read(buff, off, buff.length - off)) > 0) {
            if ((off += read) < buff.length) continue;
            off = 0;
            elements[inx++] = (Integer.MAX_VALUE & IntHashPerformance.assembleInt(buff)) % N;
        }
        if (inx < N) {
            throw new IOException("premature end of input");
        }
        in = null;
        buff = null;
        IntHashPerformance._THE_TEST_CASE_(new int[]{0, 3, 4, 3, 9, 9, 1});
        Thread.sleep(1000L);
        for (int i2 = 0; i2 < 100; ++i2) {
            int foo = i2 * 4 / 8;
        }
        long millisBegin = System.currentTimeMillis();
        int[] uniqueElements = IntHashPerformance._THE_TEST_CASE_(elements);
        long millisEnd = System.currentTimeMillis();
        if (!repeat) {
            System.err.println(millisEnd - millisBegin);
        }
        if (!repeat) {
            ArrayList<Integer> arrList = new ArrayList<Integer>();
            for (i = 0; i < uniqueElements.length; ++i) {
                arrList.add(new Integer(uniqueElements[i]));
            }
            Collections.sort(arrList);
            for (i = 0; i < arrList.size(); ++i) {
                System.out.println((Integer)arrList.get(i));
            }
        }
        if (repeat) {
            for (int i3 = 0; i3 < uniqueElements.length; ++i3) {
                uniqueElements[i3] = 0;
            }
            millisBegin = System.currentTimeMillis();
            IntHashPerformance._REPEAT_TEST_CASE_(elements, uniqueElements);
            millisEnd = System.currentTimeMillis();
            System.err.println(millisEnd - millisBegin + " (repeated test)");
            ArrayList<Integer> arrList = new ArrayList<Integer>();
            for (i = 0; i < uniqueElements.length; ++i) {
                arrList.add(new Integer(uniqueElements[i]));
            }
            Collections.sort(arrList);
            for (i = 0; i < arrList.size(); ++i) {
                System.out.println((Integer)arrList.get(i));
            }
        }
    }

    private static final int assembleInt(byte[] fourConsecutiveBytes) {
        int firstByte = (fourConsecutiveBytes[0] & 0xFF) << 24;
        int secondByte = (fourConsecutiveBytes[1] & 0xFF) << 16;
        int thirdByte = (fourConsecutiveBytes[2] & 0xFF) << 8;
        int fourthByte = (fourConsecutiveBytes[3] & 0xFF) << 0;
        return firstByte | secondByte | thirdByte | fourthByte;
    }

    private static final int[] _THE_TEST_CASE_(int[] elements) {
        _THE_HASHTABLE_ = new IntHash();
        for (int i = 0; i < elements.length; ++i) {
            _THE_HASHTABLE_.put(elements[i]);
        }
        IntEnumerator iter = _THE_HASHTABLE_.elements();
        int[] returnThis = new int[iter.numRemaining()];
        for (int i = 0; i < returnThis.length; ++i) {
            returnThis[i] = iter.nextInt();
        }
        return returnThis;
    }

    private static final void _REPEAT_TEST_CASE_(int[] elements, int[] output) {
        _THE_HASHTABLE_.empty();
        for (int i = 0; i < elements.length; ++i) {
            _THE_HASHTABLE_.put(elements[i]);
        }
        IntEnumerator iter = _THE_HASHTABLE_.elements();
        if (iter.numRemaining() != output.length) {
            throw new IllegalStateException("output aray is incorrect size");
        }
        for (int i = 0; i < output.length; ++i) {
            output[i] = iter.nextInt();
        }
    }
}

