/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util;

import cytoscape.util.MathUtil;
import cytoscape.util.RankScaler;
import junit.framework.TestCase;

public class RankScalerTest
extends TestCase {
    public void test1() {
        RankScaler rankScaler = new RankScaler();
        double[] unscaledValues = new double[]{3.0, 10.2, 5.4, 3.0, 7.7};
        double MIN = 0.0;
        double MAX = 1.0;
        double[] scaledValues = rankScaler.scale(unscaledValues, 0.0, 1.0);
        boolean foundMin = false;
        boolean foundMax = false;
        for (double d : scaledValues) {
            if (MathUtil.almostEqual(0.0, d)) {
                foundMin = true;
            }
            if (MathUtil.almostEqual(1.0, d)) {
                foundMax = true;
            }
            RankScalerTest.assertTrue(d >= 0.0 && d <= 1.0);
        }
        RankScalerTest.assertFalse(foundMin);
        RankScalerTest.assertFalse(foundMax);
    }

    public void test2() {
        RankScaler rankScaler = new RankScaler();
        double[] unscaledValues = new double[]{3.0, 3.0, 1.4, 7.7};
        double MIN = 0.0;
        double MAX = 1.0;
        double[] scaledValues = rankScaler.scale(unscaledValues, 0.0, 1.0);
        RankScalerTest.assertEquals(0.5, scaledValues[0], 1.0E-10);
        RankScalerTest.assertEquals(0.5, scaledValues[1], 1.0E-10);
        RankScalerTest.assertEquals(0.125, scaledValues[2], 1.0E-10);
        RankScalerTest.assertEquals(0.875, scaledValues[3], 1.0E-10);
    }
}

