/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.plugin;

import cytoscape.plugin.DownloadableInfo;
import cytoscape.plugin.Installable;
import cytoscape.plugin.InstallablePlugin;
import cytoscape.plugin.ManagerException;
import cytoscape.plugin.PluginInfo;
import cytoscape.plugin.PluginInquireAction;
import cytoscape.plugin.PluginManagerInquireTask;
import cytoscape.plugin.ThemeInfo;
import cytoscape.task.TaskMonitor;
import cytoscape.task.util.TaskManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jdom.JDOMException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallableTheme
implements Installable {
    private ThemeInfo infoObj;

    public InstallableTheme(ThemeInfo obj) {
        this.infoObj = obj;
    }

    @Override
    public DownloadableInfo getInfoObj() {
        return this.infoObj;
    }

    @Override
    public boolean install() throws IOException, ManagerException {
        return this.installToDir(null, null);
    }

    @Override
    public boolean installToDir(File dir) throws IOException, ManagerException {
        return this.installToDir(dir, null);
    }

    @Override
    public boolean installToDir(File dir, TaskMonitor taskMonitor) throws IOException, ManagerException {
        File InstallDir = dir;
        if (InstallDir == null) {
            InstallDir = new File(this.infoObj.getInstallLocation());
        }
        if (!InstallDir.exists()) {
            InstallDir.mkdirs();
        }
        for (PluginInfo plugin : this.infoObj.getPlugins()) {
            InstallablePlugin pi = new InstallablePlugin(plugin);
            try {
                pi.installToDir(InstallDir, taskMonitor);
                this.infoObj.replacePlugin(plugin, pi.getInfoObj());
            }
            catch (Exception me) {
                for (PluginInfo pInfo : this.infoObj.getPlugins()) {
                    if (pInfo.equals(plugin)) continue;
                    InstallablePlugin ipDelete = new InstallablePlugin(pInfo);
                    ipDelete.uninstall();
                }
                throw new ManagerException("Failed to install the theme '" + this.infoObj.toString() + "'", me);
            }
        }
        return true;
    }

    @Override
    public boolean install(TaskMonitor taskMonitor) throws IOException, ManagerException {
        return this.installToDir(null, taskMonitor);
    }

    @Override
    public boolean uninstall() throws ManagerException {
        boolean deleteOk = true;
        for (PluginInfo plugin : this.infoObj.getPlugins()) {
            InstallablePlugin ins = new InstallablePlugin(plugin);
            if (ins.uninstall()) continue;
            deleteOk = false;
        }
        deleteOk = new File(this.infoObj.getInstallLocation()).delete();
        return deleteOk;
    }

    @Override
    public List<DownloadableInfo> findUpdates() throws IOException, JDOMException {
        final ArrayList<DownloadableInfo> UpdatableThemes = new ArrayList<DownloadableInfo>();
        final HashSet<ThemeInfo> Seen = new HashSet<ThemeInfo>();
        Seen.add(this.infoObj);
        if (this.infoObj.getDownloadableURL() == null || this.infoObj.getDownloadableURL().length() <= 0) {
            return UpdatableThemes;
        }
        final ThemeInfo InfoToUpdate = this.infoObj;
        final ArrayList Exceptions = new ArrayList();
        PluginManagerInquireTask task = new PluginManagerInquireTask(this.infoObj.getDownloadableURL(), new PluginInquireAction(){

            @Override
            public String getProgressBarMessage() {
                return "Connecting to " + InfoToUpdate.getDownloadableURL() + " to search for updates...";
            }

            @Override
            public void inquireAction(List<DownloadableInfo> Results) {
                if (this.isExceptionThrown()) {
                    Exceptions.add(0, this.getIOException());
                    Exceptions.add(1, this.getJDOMException());
                }
                for (DownloadableInfo New : Results) {
                    ThemeInfo temp = InfoToUpdate;
                    if (!InfoToUpdate.getType().equals((Object)New.getType())) continue;
                    boolean newer = InfoToUpdate.isNewerObjectVersion(New);
                    if (!New.getID().equals(InfoToUpdate.getID()) || !newer) continue;
                    if (!Seen.contains(New) && newer) {
                        UpdatableThemes.add(New);
                        continue;
                    }
                    Seen.add(New);
                }
            }
        });
        TaskManager.executeTask(task, null);
        if (Exceptions.size() > 0) {
            if (Exceptions.get(0) != null) {
                throw (IOException)Exceptions.get(0);
            }
            if (Exceptions.size() > 1 && Exceptions.get(1) != null) {
                throw (JDOMException)Exceptions.get(1);
            }
        }
        return UpdatableThemes;
    }

    @Override
    public boolean update(DownloadableInfo newInfoObj, TaskMonitor taskMonitor) throws IOException, ManagerException {
        ThemeInfo newObj = (ThemeInfo)newInfoObj;
        if (this.infoObj.getDownloadableURL() == null) {
            throw new ManagerException(this.infoObj.getName() + " does not have a project url.\nCannot auto-update this plugin.");
        }
        if (!(this.infoObj.getID().equals(newObj.getID()) && this.infoObj.getDownloadableURL().equals(newObj.getDownloadableURL()) && this.infoObj.isNewerObjectVersion(newObj))) {
            throw new ManagerException("Failed to update '" + this.infoObj.getName() + "', the new plugin did not match what is currently installed\n" + "or the version was not newer than what is currently installed.");
        }
        this.infoObj = newObj;
        this.install(taskMonitor);
        return true;
    }

    @Override
    public boolean update(DownloadableInfo newInfoObj) throws IOException, ManagerException {
        return this.update(newInfoObj, null);
    }
}

