/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.dialogs.plugins;

import cytoscape.Cytoscape;
import cytoscape.dialogs.plugins.LicenseDialog;
import cytoscape.dialogs.plugins.ManagerModel;
import cytoscape.dialogs.plugins.TreeNode;
import cytoscape.logger.CyLogger;
import cytoscape.plugin.DownloadableInfo;
import cytoscape.plugin.ManagerException;
import cytoscape.plugin.PluginInfo;
import cytoscape.plugin.PluginManager;
import cytoscape.plugin.ThemeInfo;
import cytoscape.plugin.WebstartException;
import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;
import cytoscape.task.ui.JTaskConfig;
import cytoscape.task.util.TaskManager;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.jdesktop.layout.GroupLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginUpdateDialog
extends JDialog
implements TreeSelectionListener {
    private static String title = "Update Plugins";
    private static CyLogger logger = CyLogger.getLogger(PluginUpdateDialog.class);
    private JButton closeButton;
    private JScrollPane infoScrollPane;
    private JEditorPane infoTextPane;
    private JSplitPane jSplitPane1;
    private JLabel msgLabel;
    private JTree pluginTree;
    private JScrollPane treeScrollPane;
    private JButton updateAllButton;
    private JLabel updateLabel;
    private JButton updateSelectedButton;
    private TreeNode rootTreeNode;
    private ManagerModel treeModel;

    public PluginUpdateDialog(JDialog owner) {
        super((Dialog)owner, title);
        this.setLocationRelativeTo(owner);
        this.initComponents();
        this.initTree();
    }

    public PluginUpdateDialog(JFrame owner) {
        super((Frame)owner, title);
        this.setLocationRelativeTo(owner);
        this.initComponents();
        this.initTree();
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        this.infoTextPane.setContentType("text/html");
        TreePath[] Paths = this.pluginTree.getSelectionPaths();
        if (Paths == null) {
            this.updateSelectedButton.setEnabled(false);
            return;
        }
        if (Paths.length == 0) {
            this.updateSelectedButton.setEnabled(false);
        }
        for (int i = 0; i < Paths.length; ++i) {
            TreeNode LastSelectedNode = (TreeNode)Paths[i].getLastPathComponent();
            if (LastSelectedNode.isLeaf()) {
                PluginInfo New = (PluginInfo)LastSelectedNode.getObject();
                this.infoTextPane.setText(New.htmlOutput());
                this.updateSelectedButton.setEnabled(true);
                continue;
            }
            if (LastSelectedNode.getObject() == null || !LastSelectedNode.getObject().getClass().equals(PluginInfo.class)) continue;
            PluginInfo NodeInfo = (PluginInfo)LastSelectedNode.getObject();
            this.infoTextPane.setText(NodeInfo.htmlOutput());
        }
    }

    public void addCategory(String CategoryName, DownloadableInfo CurrentPlugin, List<DownloadableInfo> NewPlugins) {
        TreeNode Category2 = new TreeNode(CategoryName, true);
        this.treeModel.addNodeToParent(this.rootTreeNode, Category2);
        TreeNode CurrentPluginNode = new TreeNode(CurrentPlugin, true);
        this.treeModel.addNodeToParent(Category2, CurrentPluginNode);
        for (DownloadableInfo New : NewPlugins) {
            this.treeModel.addNodeToParent(CurrentPluginNode, new TreeNode(New));
        }
    }

    public void setMessage(String Msg) {
        this.msgLabel.setText(Msg);
    }

    private void updateSelectedButtonActionPerformed(ActionEvent evt) {
        HashSet<TreeNode> AllParents = new HashSet<TreeNode>();
        TreePath[] Paths = this.pluginTree.getSelectionPaths();
        HashMap<DownloadableInfo, DownloadableInfo> UpdatableObjs = new HashMap<DownloadableInfo, DownloadableInfo>();
        String Msg = "Please choose just one update option for the following plugins:\n";
        boolean TooManyChildren = false;
        for (TreePath Path2 : Paths) {
            TreeNode Node2 = (TreeNode)Path2.getLastPathComponent();
            TreeNode Parent2 = Node2.getParent();
            if (AllParents.contains(Parent2)) {
                Msg = Msg + Parent2.toString() + "\n";
                TooManyChildren = true;
                continue;
            }
            AllParents.add(Parent2);
            UpdatableObjs.put(Parent2.getObject(), Node2.getObject());
            this.treeModel.removeNodeFromParent(Node2);
        }
        if (TooManyChildren) {
            JOptionPane.showMessageDialog(this, Msg, "Warning: Too many updates selected", 2);
            return;
        }
        List<DownloadableInfo[]> Updatable = this.getUpdateList(UpdatableObjs);
        this.createUpdateTask(Updatable);
        this.setMessage("Update will complete when Cytoscape is restarted.");
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void updateAllButtonActionPerformed(ActionEvent evt) {
        if (JOptionPane.showConfirmDialog(this, "All plugins will be updated to the newest available version.\nIf you wish to choose a different version please press \"No\" then\nchoose each version and \"Update Selected Plugins\"", "Warning", 0) == 1) {
            return;
        }
        HashMap<DownloadableInfo, DownloadableInfo> UpdateableObjs = new HashMap<DownloadableInfo, DownloadableInfo>();
        HashSet<TreeNode> RemovableNodes = new HashSet<TreeNode>();
        List<TreeNode> Leaves = this.recursiveReadTree(this.rootTreeNode);
        for (TreeNode Node2 : Leaves) {
            TreeNode Parent2 = Node2.getParent();
            if (Parent2.getChildCount() > 1) {
                DownloadableInfo LastInfoObj = null;
                for (TreeNode Sib : Parent2.getChildren()) {
                    DownloadableInfo CurrentInfoObj = Sib.getObject();
                    if (LastInfoObj == null || LastInfoObj.isNewerObjectVersion(CurrentInfoObj)) {
                        UpdateableObjs.put(Parent2.getObject(), CurrentInfoObj);
                    }
                    LastInfoObj = CurrentInfoObj;
                }
            } else {
                UpdateableObjs.put(Parent2.getObject(), Node2.getObject());
            }
            RemovableNodes.add(Parent2);
        }
        List<DownloadableInfo[]> ObjToUpdate = this.getUpdateList(UpdateableObjs);
        this.createUpdateTask(ObjToUpdate);
        for (TreeNode Node3 : RemovableNodes) {
            this.treeModel.removeNodeFromParent(Node3);
        }
        this.setMessage("Update will complete when Cytoscape is restarted.");
    }

    private List<DownloadableInfo[]> getUpdateList(Map<DownloadableInfo, DownloadableInfo> PotentialUpdates) {
        final ArrayList<DownloadableInfo[]> Updates = new ArrayList<DownloadableInfo[]>();
        Iterator<DownloadableInfo> i$ = PotentialUpdates.keySet().iterator();
        while (i$.hasNext()) {
            DownloadableInfo Original;
            final DownloadableInfo Old = Original = i$.next();
            final DownloadableInfo New = PotentialUpdates.get(Old);
            final LicenseDialog ld = new LicenseDialog();
            boolean showLicense = false;
            switch (New.getType()) {
                case PLUGIN: {
                    if (!New.isLicenseRequired() || New.getLicenseText() == null) break;
                    ld.addPlugin(New);
                    showLicense = true;
                    break;
                }
                case THEME: {
                    ThemeInfo themeInfo = (ThemeInfo)New;
                    for (PluginInfo pInfo : themeInfo.getPlugins()) {
                        if (!pInfo.isLicenseRequired() || pInfo.getLicenseText() == null) continue;
                        ld.addPlugin(pInfo);
                        showLicense = true;
                    }
                    break;
                }
            }
            if (showLicense) {
                ld.addListenerToOk(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        Updates.add(new DownloadableInfo[]{Old, New});
                        ld.dispose();
                    }
                });
                ld.selectDefault();
                ld.setVisible(true);
                continue;
            }
            Updates.add(new DownloadableInfo[]{Old, New});
        }
        return Updates;
    }

    private List<TreeNode> recursiveReadTree(TreeNode Node2) {
        ArrayList<TreeNode> LeafNodes = new ArrayList<TreeNode>();
        for (TreeNode Child2 : Node2.getChildren()) {
            if (!Child2.isLeaf()) {
                List<TreeNode> DeeperNodes = this.recursiveReadTree(Child2);
                LeafNodes.addAll(DeeperNodes);
                continue;
            }
            LeafNodes.add(Child2);
        }
        return LeafNodes;
    }

    private void initTree() {
        this.rootTreeNode = new TreeNode("Updatable Plugins", true);
        this.pluginTree.addTreeSelectionListener(this);
        this.pluginTree.getSelectionModel().setSelectionMode(4);
        this.treeModel = new ManagerModel(this.rootTreeNode);
        this.pluginTree.setModel(this.treeModel);
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.infoScrollPane = new JScrollPane();
        this.infoTextPane = new JEditorPane();
        this.treeScrollPane = new JScrollPane();
        this.pluginTree = new JTree();
        this.updateLabel = new JLabel();
        this.updateAllButton = new JButton();
        this.updateSelectedButton = new JButton();
        this.closeButton = new JButton();
        this.msgLabel = new JLabel();
        this.setDefaultCloseOperation(2);
        this.jSplitPane1.setDividerLocation(250);
        this.infoScrollPane.setViewportView(this.infoTextPane);
        this.jSplitPane1.setRightComponent(this.infoScrollPane);
        this.treeScrollPane.setViewportView(this.pluginTree);
        this.jSplitPane1.setLeftComponent(this.treeScrollPane);
        this.updateLabel.setLabelFor(this.jSplitPane1);
        this.updateLabel.setText("Listed are updates available for currently installed plugins");
        this.updateLabel.setVerticalAlignment(1);
        this.updateAllButton.setText("Update All");
        this.updateAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PluginUpdateDialog.this.updateAllButtonActionPerformed(evt);
            }
        });
        this.updateSelectedButton.setText("Update Selected");
        this.updateSelectedButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PluginUpdateDialog.this.updateSelectedButtonActionPerformed(evt);
            }
        });
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PluginUpdateDialog.this.closeButtonActionPerformed(evt);
            }
        });
        this.msgLabel.setForeground(Color.BLACK);
        this.msgLabel.setVerticalAlignment(1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(43, 43, 43).add(layout.createParallelGroup(2).add(1, this.updateLabel, -1, 574, Short.MAX_VALUE).add(1, this.jSplitPane1, -1, 574, Short.MAX_VALUE).add(1, this.msgLabel, -1, 574, Short.MAX_VALUE)).add(41, 41, 41)).add(2, layout.createSequentialGroup().addContainerGap(272, Short.MAX_VALUE).add(this.updateAllButton).add(18, 18, 18).add(this.updateSelectedButton).add(22, 22, 22).add(this.closeButton).add(50, 50, 50)));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(this.updateLabel, -2, 32, -2).addPreferredGap(0).add(this.jSplitPane1, -1, 324, Short.MAX_VALUE).addPreferredGap(0).add(this.msgLabel, -1, 33, Short.MAX_VALUE).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.updateAllButton).add(this.updateSelectedButton).add(this.closeButton)).addContainerGap()));
        this.pack();
    }

    private void createUpdateTask(List<DownloadableInfo[]> UpdateObjs) {
        PluginUpdateTask task = new PluginUpdateTask(UpdateObjs);
        JTaskConfig jTaskConfig = new JTaskConfig();
        jTaskConfig.setOwner(Cytoscape.getDesktop());
        jTaskConfig.displayCloseButton(false);
        jTaskConfig.displayStatus(true);
        jTaskConfig.setAutoDispose(true);
        jTaskConfig.displayCancelButton(true);
        TaskManager.executeTask(task, jTaskConfig);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PluginUpdateTask
    implements Task {
        private TaskMonitor taskMonitor;
        private List<DownloadableInfo[]> toUpdate;

        public PluginUpdateTask(List<DownloadableInfo[]> Updates) {
            this.toUpdate = Updates;
        }

        @Override
        public void run() {
            if (this.taskMonitor == null) {
                throw new IllegalStateException("Task Monitor is not set.");
            }
            this.taskMonitor.setStatus("Updating...");
            this.taskMonitor.setPercentCompleted(-1);
            PluginManager Mgr = PluginManager.getPluginManager();
            for (DownloadableInfo[] UpdatePair : this.toUpdate) {
                this.taskMonitor.setStatus("Updating " + UpdatePair[0].getName() + " to version " + UpdatePair[1].getObjectVersion());
                try {
                    Mgr.update(UpdatePair[0], UpdatePair[1], this.taskMonitor);
                }
                catch (IOException ioe) {
                    this.taskMonitor.setException(ioe, "Failed to download " + UpdatePair[1].getName());
                }
                catch (ManagerException me) {
                    JOptionPane.showMessageDialog(PluginUpdateDialog.this, me.getMessage(), "Error", 0);
                }
                catch (WebstartException we) {
                    logger.warn("Unable to update '" + UpdatePair[1].getName() + "': " + we.getMessage(), we);
                }
            }
            this.taskMonitor.setPercentCompleted(100);
        }

        @Override
        public void halt() {
        }

        @Override
        public void setTaskMonitor(TaskMonitor monitor) throws IllegalThreadStateException {
            this.taskMonitor = monitor;
        }

        @Override
        public String getTitle() {
            return "Updating Plugins";
        }
    }
}

