/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.actions;

import cytoscape.Cytoscape;
import cytoscape.actions.OpenSessionAction;
import cytoscape.data.readers.CytoscapeSessionReader;
import cytoscape.data.readers.XGMMLException;
import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import javax.xml.bind.JAXBException;

class OpenSessionTask
implements Task {
    private String fileName;
    private TaskMonitor taskMonitor;

    OpenSessionTask(String fileName) {
        this.fileName = fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block7: {
            this.taskMonitor.setStatus("Opening Session File.\n\nIt may take a while.\nPlease wait...");
            this.taskMonitor.setPercentCompleted(0);
            try {
                CytoscapeSessionReader sr2;
                try {
                    sr2 = new CytoscapeSessionReader(this.fileName, this.taskMonitor);
                    sr2.read();
                }
                catch (IOException e) {
                    this.taskMonitor.setException(e, "Cannot open the session file: " + e.getMessage());
                    OpenSessionAction.logger.error("Cannot open the session file: " + e.getMessage(), e);
                    Object var4_8 = null;
                    Object sr2 = null;
                    Cytoscape.getDesktop().getVizMapperUI().initVizmapperGUI();
                    System.gc();
                    break block7;
                }
                catch (JAXBException e) {
                    this.taskMonitor.setException(e, "Cannot unmarshall document: " + e.getMessage());
                    OpenSessionAction.logger.error("Cannot unmarshall document: " + e.getMessage(), e);
                    Object var4_9 = null;
                    Object sr2 = null;
                    Cytoscape.getDesktop().getVizMapperUI().initVizmapperGUI();
                    System.gc();
                    break block7;
                }
                catch (XGMMLException e) {
                    this.taskMonitor.setException(e, "XGMML format error in network: " + e.getMessage());
                    OpenSessionAction.logger.error("XGMML format error in network " + e.getMessage(), e);
                    Object var4_10 = null;
                    Object sr2 = null;
                    Cytoscape.getDesktop().getVizMapperUI().initVizmapperGUI();
                    System.gc();
                    break block7;
                }
                catch (Exception e) {
                    this.taskMonitor.setException(e, "Error while loading session " + e.getMessage());
                    OpenSessionAction.logger.error("Error while loading session: " + e.getMessage(), e);
                    Object var4_11 = null;
                    Object sr2 = null;
                    Cytoscape.getDesktop().getVizMapperUI().initVizmapperGUI();
                    System.gc();
                    break block7;
                }
                Object var4_7 = null;
                sr2 = null;
                Cytoscape.getDesktop().getVizMapperUI().initVizmapperGUI();
            }
            catch (Throwable throwable) {
                Object var4_12 = null;
                Object sr2 = null;
                Cytoscape.getDesktop().getVizMapperUI().initVizmapperGUI();
                System.gc();
                throw throwable;
            }
            System.gc();
        }
        this.taskMonitor.setPercentCompleted(100);
        this.taskMonitor.setStatus("Session file " + this.fileName + " successfully loaded.");
        Cytoscape.setCurrentSessionFileName(this.fileName);
        File sessionFile = new File(this.fileName);
        Cytoscape.getDesktop().setTitle("Cytoscape Desktop (Session: " + sessionFile.getName() + ")");
    }

    public void halt() {
        OpenSessionAction.logger.info("HALT called!!!");
        this.taskMonitor.setPercentCompleted(100);
        this.taskMonitor.setStatus("Failed!!!");
    }

    public void setTaskMonitor(TaskMonitor taskMonitor) throws IllegalThreadStateException {
        this.taskMonitor = taskMonitor;
    }

    public String getTitle() {
        return "Opening Session File";
    }
}

