/*
 * Decompiled with CFR 0.152.
 */
package com.sosnoski.util.array;

import com.sosnoski.util.array.ArrayBase;

public class CharArray
extends ArrayBase {
    protected char[] m_baseArray;

    public CharArray(int n, int n2) {
        super(n, n2, Character.TYPE);
    }

    public CharArray(int n) {
        super(n, Character.TYPE);
    }

    public CharArray() {
        this(8);
    }

    public CharArray(CharArray charArray) {
        super(charArray);
    }

    protected final Object getArray() {
        return this.m_baseArray;
    }

    protected final void setArray(Object object) {
        this.m_baseArray = (char[])object;
    }

    public final int add(int n) {
        int n2 = this.getAddIndex();
        this.m_baseArray[n2] = (char)n;
        return n2;
    }

    public void add(int n, int n2) {
        this.makeInsertSpace(n);
        this.m_baseArray[n] = (char)n2;
    }

    public final char get(int n) {
        if (n < this.m_countPresent) {
            return this.m_baseArray[n];
        }
        throw new ArrayIndexOutOfBoundsException("Invalid index value");
    }

    public final void set(int n, int n2) {
        if (n >= this.m_countPresent) {
            throw new ArrayIndexOutOfBoundsException("Invalid index value");
        }
        this.m_baseArray[n] = (char)n2;
    }

    public char[] toArray() {
        return (char[])this.buildArray(Character.TYPE, 0, this.m_countPresent);
    }

    public char[] toArray(int n, int n2) {
        return (char[])this.buildArray(Character.TYPE, n, n2);
    }

    public Object clone() {
        return new CharArray(this);
    }
}

