/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations;

import java.util.HashMap;
import junit.framework.TestCase;
import org.cytoscape.equations.EqnParser;
import org.cytoscape.equations.Parser;

public class AttribParserTest
extends TestCase {
    private final EqnParser parser = Parser.getParser();

    public void testSimpleExpr() throws Exception {
        HashMap<String, Class> attribNameToTypeMap = new HashMap<String, Class>();
        attribNameToTypeMap.put("BOB", Double.class);
        AttribParserTest.assertTrue(this.parser.parse("=42 - 12 + 3 * (4 - 2) + ${BOB:12}", attribNameToTypeMap));
    }

    public void testUnaryPlusAndMinus() throws Exception {
        HashMap<String, Class> attribNameToTypeMap = new HashMap<String, Class>();
        attribNameToTypeMap.put("attr1", Double.class);
        attribNameToTypeMap.put("attr2", Double.class);
        AttribParserTest.assertTrue(this.parser.parse("=-17.8E-14", attribNameToTypeMap));
        AttribParserTest.assertTrue(this.parser.parse("=+(${attr1} + ${attr2})", attribNameToTypeMap));
    }

    public void testFunctionCall() throws Exception {
        HashMap<String, Class> attribNameToTypeMap = new HashMap<String, Class>();
        AttribParserTest.assertTrue(this.parser.parse("=42 + log(4 - 2)", attribNameToTypeMap));
    }

    public void testExponentiation() throws Exception {
        HashMap<String, Class> attribNameToTypeMap = new HashMap<String, Class>();
        AttribParserTest.assertTrue(this.parser.parse("=2^3^4 - 0.0002", attribNameToTypeMap));
    }

    public void testComparisons() throws Exception {
        HashMap<String, Class> attribNameToTypeMap = new HashMap<String, Class>();
        attribNameToTypeMap.put("x", Double.class);
        attribNameToTypeMap.put("y", Double.class);
        attribNameToTypeMap.put("limit", Double.class);
        AttribParserTest.assertTrue(this.parser.parse("=${x} <= ${y}", attribNameToTypeMap));
        AttribParserTest.assertTrue(this.parser.parse("=-15.4^3 > ${limit}", attribNameToTypeMap));
    }

    public void testVarargs() throws Exception {
        HashMap<String, Class> attribNameToTypeMap = new HashMap<String, Class>();
        AttribParserTest.assertFalse(this.parser.parse("=LOG()", attribNameToTypeMap));
        AttribParserTest.assertTrue(this.parser.parse("=LOG(1)", attribNameToTypeMap));
        AttribParserTest.assertTrue(this.parser.parse("=LOG(1,2)", attribNameToTypeMap));
        AttribParserTest.assertFalse(this.parser.parse("=LOG(1,2,3)", attribNameToTypeMap));
    }

    public void testFixedargs() throws Exception {
        HashMap<String, Class> attribNameToTypeMap = new HashMap<String, Class>();
        AttribParserTest.assertFalse(this.parser.parse("=ABS()", attribNameToTypeMap));
        AttribParserTest.assertTrue(this.parser.parse("=ABS(1)", attribNameToTypeMap));
        AttribParserTest.assertFalse(this.parser.parse("=ABS(1,2)", attribNameToTypeMap));
    }

    public void testNOT() throws Exception {
        HashMap<String, Class> attribNameToTypeMap = new HashMap<String, Class>();
        attribNameToTypeMap.put("logical", Boolean.class);
        AttribParserTest.assertFalse(this.parser.parse("=NOT()", attribNameToTypeMap));
        AttribParserTest.assertTrue(this.parser.parse("=NOT(true)", attribNameToTypeMap));
        AttribParserTest.assertTrue(this.parser.parse("=NOT(false)", attribNameToTypeMap));
        AttribParserTest.assertTrue(this.parser.parse("=NOT(3.2 < 12)", attribNameToTypeMap));
        AttribParserTest.assertTrue(this.parser.parse("=NOT(${logical})", attribNameToTypeMap));
        AttribParserTest.assertFalse(this.parser.parse("=NOT(true, true)", attribNameToTypeMap));
    }

    public void testUPPERandLOWER() throws Exception {
        HashMap<String, Class> attribNameToTypeMap = new HashMap<String, Class>();
        AttribParserTest.assertTrue(this.parser.parse("=UPPER(\"Fred\")", attribNameToTypeMap));
        AttribParserTest.assertTrue(this.parser.parse("=\"bozo\"&LOWER(\"UPPER\")", attribNameToTypeMap));
    }

    public void testBracelessAttribReferences() throws Exception {
        HashMap<String, Class> attribNameToTypeMap = new HashMap<String, Class>();
        attribNameToTypeMap.put("BOB", Double.class);
        attribNameToTypeMap.put("FRED", Double.class);
        AttribParserTest.assertTrue(this.parser.parse("=$BOB+$FRED", attribNameToTypeMap));
    }

    public void testIntegerToFloatingPointConversion() throws Exception {
        HashMap<String, Class> attribNameToTypeMap = new HashMap<String, Class>();
        attribNameToTypeMap.put("BOB", Long.class);
        AttribParserTest.assertTrue(this.parser.parse("=$BOB > 5.3", attribNameToTypeMap));
    }

    public void testMixedModeArithmetic() throws Exception {
        HashMap<String, Class> attribNameToTypeMap = new HashMap<String, Class>();
        attribNameToTypeMap.put("x", Long.class);
        AttribParserTest.assertTrue(this.parser.parse("=$x + 2.0", attribNameToTypeMap));
    }
}

