/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.ui.editors.discrete;

import com.l2fprod.common.swing.renderer.DefaultCellRenderer;
import cytoscape.visual.customgraphic.CustomGraphicsUtil;
import cytoscape.visual.customgraphic.CyCustomGraphics;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;

public class CustomGraphicsCellRenderer
extends DefaultCellRenderer {
    private static final long serialVersionUID = 381040361846340312L;
    private Map<CyCustomGraphics, Icon> iconMap = new HashMap<CyCustomGraphics, Icon>();

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel label = new JLabel();
        if (isSelected) {
            label.setBackground(table.getSelectionBackground());
            label.setForeground(table.getSelectionForeground());
        } else {
            label.setBackground(table.getBackground());
            label.setForeground(table.getForeground());
        }
        if (value != null && value instanceof CyCustomGraphics) {
            CyCustomGraphics cg = (CyCustomGraphics)value;
            Icon icon = this.iconMap.get(cg);
            if (icon == null && cg.getRenderedImage() != null) {
                label.setIcon(new ImageIcon(CustomGraphicsUtil.getResizedImage(cg.getRenderedImage(), 96, null, true)));
            } else {
                label.setIcon(icon);
            }
            label.setText(cg.getDisplayName());
            label.setVerticalAlignment(0);
            label.setHorizontalAlignment(0);
        }
        return label;
    }
}

