/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.ui.editors.continuous;

import cytoscape.Cytoscape;
import cytoscape.util.CyColorChooser;
import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.mappings.BoundaryRangeValues;
import cytoscape.visual.mappings.ContinuousMapping;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class BelowAndAbovePanel
extends JPanel {
    private VisualPropertyType type;
    private Color boxColor;
    private boolean below;
    private Object value;
    public static final String COLOR_CHANGED = "COLOR_CHANGED";

    public BelowAndAbovePanel(VisualPropertyType type, Color color, boolean below) {
        this.boxColor = color;
        this.below = below;
        this.type = type;
        if (below) {
            this.setToolTipText("Double-click triangle to set below color...");
        } else {
            this.setToolTipText("Double-click triangle to set above color...");
        }
        this.addMouseListener(new MouseEventHandler(this));
    }

    public BelowAndAbovePanel(VisualPropertyType type, boolean below) {
        this(type, Color.DARK_GRAY, below);
    }

    public void setColor(Color newColor) {
        Color oldColor = this.boxColor;
        this.boxColor = newColor;
        this.repaint();
        this.getParent().repaint();
        this.firePropertyChange(COLOR_CHANGED, oldColor, newColor);
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Polygon poly = new Polygon();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setStroke(new BasicStroke(1.0f));
        g2d.setColor(this.boxColor);
        if (this.below) {
            poly.addPoint(9, 0);
            poly.addPoint(9, 10);
            poly.addPoint(0, 5);
        } else {
            poly.addPoint(0, 0);
            poly.addPoint(0, 10);
            poly.addPoint(9, 5);
        }
        g2d.fillPolygon(poly);
        g2d.setColor(Color.black);
        g2d.draw(poly);
    }

    class MouseEventHandler
    extends MouseAdapter {
        private BelowAndAbovePanel caller;

        public MouseEventHandler(BelowAndAbovePanel c) {
            this.caller = c;
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                Serializable newValue = null;
                if (BelowAndAbovePanel.this.type.getDataType() == Color.class) {
                    newValue = CyColorChooser.showDialog(this.caller, "Select new color", BelowAndAbovePanel.this.boxColor);
                    this.caller.setColor((Color)newValue);
                } else if (BelowAndAbovePanel.this.type.getDataType() == Number.class) {
                    newValue = Double.valueOf(Double.parseDouble(JOptionPane.showInputDialog(this.caller, (Object)"Please enter new value.")));
                    this.caller.setValue(newValue);
                }
                if (newValue == null) {
                    return;
                }
                ContinuousMapping cMapping = BelowAndAbovePanel.this.type.isNodeProp() ? (ContinuousMapping)Cytoscape.getVisualMappingManager().getVisualStyle().getNodeAppearanceCalculator().getCalculator(BelowAndAbovePanel.this.type).getMapping(0) : (ContinuousMapping)Cytoscape.getVisualMappingManager().getVisualStyle().getEdgeAppearanceCalculator().getCalculator(BelowAndAbovePanel.this.type).getMapping(0);
                if (BelowAndAbovePanel.this.below) {
                    BoundaryRangeValues original = cMapping.getPoint(0).getRange();
                    BoundaryRangeValues brv = new BoundaryRangeValues(newValue, original.equalValue, original.greaterValue);
                    cMapping.getPoint(0).setRange(brv);
                } else {
                    BoundaryRangeValues original = cMapping.getPoint(cMapping.getPointCount() - 1).getRange();
                    BoundaryRangeValues brv = new BoundaryRangeValues(original.lesserValue, original.equalValue, newValue);
                    cMapping.getPoint(cMapping.getPointCount() - 1).setRange(brv);
                }
                cMapping.fireStateChanged();
                Cytoscape.getVisualMappingManager().getNetworkView().redrawGraph(false, true);
                this.caller.repaint();
                this.caller.getParent().repaint();
            }
        }
    }
}

