/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.view;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.actions.CreateNetworkViewAction;
import cytoscape.logger.CyLogger;
import cytoscape.util.CyNetworkNaming;
import cytoscape.view.CyNetworkView;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JMenuItem;

class PopupActionListener
implements ActionListener {
    public static final String DESTROY_VIEW = "Destroy View";
    public static final String CREATE_VIEW = "Create View";
    public static final String DESTROY_NETWORK = "Destroy Network";
    public static final String EDIT_TITLE = "Edit Network Title";
    public static final String APPLY_VISUAL_STYLE = "Apply Visual Style";
    protected CyNetwork cyNetwork;

    PopupActionListener() {
    }

    public void actionPerformed(ActionEvent ae) {
        String label = ((JMenuItem)ae.getSource()).getText();
        if (DESTROY_VIEW.equals(label)) {
            List<CyNetwork> selected = Cytoscape.getSelectedNetworks();
            for (CyNetwork network : selected) {
                CyNetworkView targetView = Cytoscape.getNetworkView(network.getIdentifier());
                if (targetView == Cytoscape.getNullNetworkView()) continue;
                Cytoscape.destroyNetworkView(targetView);
            }
        } else if (CREATE_VIEW.equals(label)) {
            List<CyNetwork> selected = Cytoscape.getSelectedNetworks();
            for (CyNetwork network : selected) {
                if (Cytoscape.viewExists(network.getIdentifier())) continue;
                CreateNetworkViewAction.createViewFromCurrentNetwork(network);
            }
        } else if (DESTROY_NETWORK.equals(label)) {
            List<CyNetwork> selected = Cytoscape.getSelectedNetworks();
            for (CyNetwork network : selected) {
                Cytoscape.destroyNetwork(network);
            }
        } else if (EDIT_TITLE.equals(label)) {
            CyNetworkNaming.editNetworkTitle(this.cyNetwork);
            Cytoscape.getDesktop().getNetworkPanel().updateTitle(this.cyNetwork);
        } else {
            CyLogger.getLogger().warn("Unexpected network panel popup option");
        }
    }

    public void setActiveNetwork(CyNetwork cyNetwork) {
        this.cyNetwork = cyNetwork;
    }
}

