/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util;

import cytoscape.util.PropUtil;
import java.util.Properties;
import junit.framework.TestCase;

public class PropUtilTest
extends TestCase {
    Properties props;

    protected void setUp() throws Exception {
        this.props = new Properties();
    }

    public void testGoodInt() {
        this.props.setProperty("good-int-1", "123");
        PropUtilTest.assertEquals(123, PropUtil.getInt(this.props, "good-int-1", 999));
    }

    public void testBadInt() {
        this.props.setProperty("bad-int-1", " 4");
        this.props.setProperty("bad-int-2", "5 ");
        this.props.setProperty("bad-int-3", " 6 ");
        this.props.setProperty("bad-int-4", "homer");
        this.props.setProperty("bad-int-5", " x");
        this.props.setProperty("bad-int-6", "5.04 ");
        this.props.setProperty("bad-int-7", " 6.0 ");
        PropUtilTest.assertEquals(999, PropUtil.getInt(this.props, "bad-int-1", 999));
        PropUtilTest.assertEquals(999, PropUtil.getInt(this.props, "bad-int-2", 999));
        PropUtilTest.assertEquals(999, PropUtil.getInt(this.props, "bad-int-3", 999));
        PropUtilTest.assertEquals(999, PropUtil.getInt(this.props, "bad-int-4", 999));
        PropUtilTest.assertEquals(999, PropUtil.getInt(this.props, "bad-int-5", 999));
        PropUtilTest.assertEquals(999, PropUtil.getInt(this.props, "bad-int-6", 999));
        PropUtilTest.assertEquals(999, PropUtil.getInt(this.props, "bad-int-7", 999));
    }

    public void testTrueGood() {
        this.props.setProperty("true-good-1", "true");
        this.props.setProperty("true-good-2", " TRUE");
        this.props.setProperty("true-good-3", "trUe ");
        this.props.setProperty("true-good-4", "  True ");
        PropUtilTest.assertTrue(PropUtil.getBoolean(this.props, "true-good-1", false));
        PropUtilTest.assertTrue(PropUtil.getBoolean(this.props, "true-good-2", false));
        PropUtilTest.assertTrue(PropUtil.getBoolean(this.props, "true-good-3", false));
        PropUtilTest.assertTrue(PropUtil.getBoolean(this.props, "true-good-4", false));
    }

    public void testFalseGood() {
        this.props.setProperty("false-good-1", "false");
        this.props.setProperty("false-good-2", " FALSE");
        this.props.setProperty("false-good-3", "False ");
        this.props.setProperty("false-good-4", "  false ");
        PropUtilTest.assertFalse(PropUtil.getBoolean(this.props, "false-good-1", true));
        PropUtilTest.assertFalse(PropUtil.getBoolean(this.props, "false-good-2", true));
        PropUtilTest.assertFalse(PropUtil.getBoolean(this.props, "false-good-3", true));
        PropUtilTest.assertFalse(PropUtil.getBoolean(this.props, "false-good-4", true));
    }

    public void testYesGood() {
        this.props.setProperty("true-good-1", "yes");
        this.props.setProperty("true-good-2", " YES");
        this.props.setProperty("true-good-3", "yEs ");
        this.props.setProperty("true-good-4", "  YeS ");
        PropUtilTest.assertTrue(PropUtil.getBoolean(this.props, "true-good-1", false));
        PropUtilTest.assertTrue(PropUtil.getBoolean(this.props, "true-good-2", false));
        PropUtilTest.assertTrue(PropUtil.getBoolean(this.props, "true-good-3", false));
        PropUtilTest.assertTrue(PropUtil.getBoolean(this.props, "true-good-4", false));
    }

    public void testNoGood() {
        this.props.setProperty("false-good-1", "no");
        this.props.setProperty("false-good-2", " NO");
        this.props.setProperty("false-good-3", "No ");
        this.props.setProperty("false-good-4", "  nO ");
        PropUtilTest.assertFalse(PropUtil.getBoolean(this.props, "false-good-1", true));
        PropUtilTest.assertFalse(PropUtil.getBoolean(this.props, "false-good-2", true));
        PropUtilTest.assertFalse(PropUtil.getBoolean(this.props, "false-good-3", true));
        PropUtilTest.assertFalse(PropUtil.getBoolean(this.props, "false-good-4", true));
    }

    public void testTrueBad() {
        this.props.setProperty("true-bad-1", "truex");
        this.props.setProperty("true-bad-2", "true x");
        this.props.setProperty("true-bad-3", "true!");
        PropUtilTest.assertFalse(PropUtil.getBoolean(this.props, "true-bad-1", false));
        PropUtilTest.assertTrue(PropUtil.getBoolean(this.props, "true-bad-2", true));
        PropUtilTest.assertFalse(PropUtil.getBoolean(this.props, "true-bad-3", false));
    }

    public void testFalseBad() {
        this.props.setProperty("false-bad-1", "falsex");
        this.props.setProperty("false-bad-2", "false x");
        this.props.setProperty("false-bad-3", "false!");
        PropUtilTest.assertFalse(PropUtil.getBoolean(this.props, "false-bad-1", false));
        PropUtilTest.assertTrue(PropUtil.getBoolean(this.props, "false-bad-2", true));
        PropUtilTest.assertFalse(PropUtil.getBoolean(this.props, "false-bad-3", false));
    }
}

