/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util;

import cytoscape.CytoscapeInit;
import cytoscape.logger.CyLogger;
import java.io.IOException;
import java.util.Properties;

public abstract class OpenBrowser {
    static String[] LINUX_BROWSERS = new String[]{"xdg-open", "htmlview", "firefox", "mozilla", "konqueror", "chrome", "chromium"};
    static String MAC_PATH = "open";
    private static final String WIN_PATH = "rundll32";
    private static final String WIN_FLAG = "url.dll,FileProtocolHandler";

    public static void openURL(String url) {
        String osName;
        boolean succeeded;
        Properties prop = CytoscapeInit.getProperties();
        String defBrowser = prop.getProperty("defaultWebBrowser");
        if (defBrowser != null && defBrowser.equals("")) {
            defBrowser = null;
        }
        if (!(succeeded = (osName = System.getProperty("os.name")).startsWith("Windows") ? OpenBrowser.openURLOnWindows(url, defBrowser) : (osName.startsWith("Mac") ? OpenBrowser.openURLOnMac(url, defBrowser) : OpenBrowser.openURLOnLinux(url, defBrowser)))) {
            CyLogger.getLogger().error("failed to launch browser!");
        }
    }

    private static boolean openURLOnWindows(String url, String defBrowser) {
        String cmd = defBrowser != null ? defBrowser + " " + url : "rundll32 url.dll,FileProtocolHandler " + url;
        CyLogger.getLogger().info("Opening URL by command \"" + cmd + "\"");
        return OpenBrowser.tryExecute(cmd) == 0;
    }

    private static boolean openURLOnMac(String url, String defBrowser) {
        String cmd = defBrowser != null ? defBrowser + " " + url : MAC_PATH + " " + " " + url;
        CyLogger.getLogger().info("Opening URL by command \"" + cmd + "\"");
        return OpenBrowser.tryExecute(cmd) == 0;
    }

    private static boolean openURLOnLinux(String url, String defBrowser) {
        String cmd;
        if (defBrowser != null) {
            cmd = defBrowser + " " + url;
            CyLogger.getLogger().info("Opening URL by command \"" + cmd + "\"");
            if (OpenBrowser.tryExecute(cmd) == 0) {
                return true;
            }
        }
        for (String browser : LINUX_BROWSERS) {
            cmd = browser + " " + url;
            CyLogger.getLogger().info("Opening URL by command \"" + cmd + "\"");
            if (OpenBrowser.tryExecute(cmd) != 0) continue;
            return true;
        }
        return false;
    }

    private static int tryExecute(String cmd) {
        try {
            Process p = Runtime.getRuntime().exec(cmd);
            return p.waitFor();
        }
        catch (InterruptedException e) {
            CyLogger.getLogger().error("failed to execute browser command: '" + cmd + "'", e);
            return -1;
        }
        catch (IOException e) {
            CyLogger.getLogger().error("failed to execute browser command: '" + cmd + "'", e);
            return -1;
        }
    }
}

