/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.groups;

import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.groups.CyGroup;
import cytoscape.groups.CyGroupManager;
import cytoscape.groups.CyGroupViewer;
import giny.model.RootGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CyGroupImpl
implements CyGroup {
    private HashMap<CyNode, CyNode> nodeMap = new HashMap();
    private HashMap<CyEdge, CyEdge> innerEdgeMap;
    private HashMap<CyEdge, CyEdge> outerEdgeMap;
    private HashMap<CyNode, List<CyEdge>> nodeToEdgeMap = new HashMap();
    private CyNode groupNode = null;
    private String groupName = null;
    private int groupState = 0;
    private Object viewValue = null;
    private String viewer = null;

    protected CyGroupImpl() {
        this.innerEdgeMap = new HashMap();
        this.outerEdgeMap = new HashMap();
    }

    protected CyGroupImpl(String groupName) {
        this();
        this.groupNode = Cytoscape.getCyNode(groupName, true);
        this.groupName = groupName;
    }

    protected CyGroupImpl(CyNode groupNode) {
        this();
        this.groupNode = groupNode;
        this.groupName = this.groupNode.getIdentifier();
    }

    protected CyGroupImpl(CyNode groupNode, List nodeList) {
        this(groupNode);
        Iterator iter = nodeList.iterator();
        while (iter.hasNext()) {
            this.addNodeToGroup((CyNode)iter.next());
        }
    }

    protected CyGroupImpl(String groupName, List<CyNode> nodeList) {
        this(groupName);
        for (CyNode node : nodeList) {
            this.addNodeToGroup(node);
        }
    }

    @Override
    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String name) {
        this.groupName = name;
    }

    @Override
    public List<CyNode> getNodes() {
        Collection<CyNode> v = this.nodeMap.values();
        return new ArrayList<CyNode>(v);
    }

    @Override
    public CyNode getGroupNode() {
        return this.groupNode;
    }

    @Override
    public Iterator<CyNode> getNodeIterator() {
        Collection<CyNode> v = this.nodeMap.values();
        return v.iterator();
    }

    @Override
    public List<CyEdge> getInnerEdges() {
        Collection<CyEdge> v = this.innerEdgeMap.values();
        return new ArrayList<CyEdge>(v);
    }

    @Override
    public List<CyEdge> getOuterEdges() {
        Collection<CyEdge> v = this.outerEdgeMap.values();
        return new ArrayList<CyEdge>(v);
    }

    @Override
    public void addOuterEdge(CyEdge edge) {
        this.outerEdgeMap.put(edge, edge);
    }

    @Override
    public void addInnerEdge(CyEdge edge) {
        this.innerEdgeMap.put(edge, edge);
    }

    @Override
    public boolean contains(CyNode node) {
        return this.nodeMap.containsKey(node);
    }

    @Override
    public void setState(int state) {
        CyAttributes attributes = Cytoscape.getNodeAttributes();
        this.groupState = state;
        attributes.setUserVisible("__groupState", false);
        attributes.setAttribute(this.groupName, "__groupState", this.groupState);
        CyGroupViewer v = CyGroupManager.getGroupViewer(this.viewer);
        if (v != null) {
            v.groupChanged(this, null, CyGroupViewer.ChangeType.STATE_CHANGED);
        }
    }

    @Override
    public int getState() {
        return this.groupState;
    }

    public void setViewValue(Object viewValue) {
        this.viewValue = viewValue;
    }

    public Object getViewValue() {
        return this.viewValue;
    }

    @Override
    public String toString() {
        return this.groupName;
    }

    protected void setViewer(String viewerName) {
        CyAttributes attributes = Cytoscape.getNodeAttributes();
        this.viewer = viewerName;
        if (this.viewer != null) {
            attributes.setUserVisible("__groupViewer", false);
            attributes.setAttribute(this.groupName, "__groupViewer", this.viewer);
        }
    }

    @Override
    public String getViewer() {
        return this.viewer;
    }

    @Override
    public void addNode(CyNode node) {
        ArrayList<CyEdge> eMove = new ArrayList<CyEdge>();
        for (CyEdge edge : this.outerEdgeMap.keySet()) {
            if (edge.getTarget() != node && edge.getSource() != node) continue;
            eMove.add(edge);
        }
        for (CyEdge edge : eMove) {
            this.outerEdgeMap.remove(edge);
            this.innerEdgeMap.put(edge, edge);
        }
        this.nodeToEdgeMap.put(node, eMove);
        this.addNodeToGroup(node);
        CyGroupViewer v = CyGroupManager.getGroupViewer(this.viewer);
        if (v != null) {
            v.groupChanged(this, node, CyGroupViewer.ChangeType.NODE_ADDED);
        }
    }

    @Override
    public void removeNode(CyNode node) {
        this.removeNodeFromGroup(node);
        CyGroupViewer v = CyGroupManager.getGroupViewer(this.viewer);
        if (v != null) {
            v.groupChanged(this, node, CyGroupViewer.ChangeType.NODE_REMOVED);
        }
    }

    private void addNodeToGroup(CyNode node) {
        this.nodeMap.put(node, node);
        CyNetwork network = Cytoscape.getCurrentNetwork();
        List<Object> edgeList = null;
        edgeList = this.nodeToEdgeMap.containsKey(node) ? this.nodeToEdgeMap.get(node) : new ArrayList();
        int[] edgeArray = network.getAdjacentEdgeIndicesArray(node.getRootGraphIndex(), true, true, true);
        if (edgeArray == null) {
            edgeArray = new int[]{};
        }
        for (int edgeIndex = 0; edgeIndex < edgeArray.length; ++edgeIndex) {
            CyEdge edge = (CyEdge)network.getEdge(edgeArray[edgeIndex]);
            if (edgeList.contains(edge)) continue;
            edgeList.add(edge);
            CyNode target = (CyNode)edge.getTarget();
            CyNode source = (CyNode)edge.getSource();
            if (source == this.groupNode || target == this.groupNode) continue;
            if (this.outerEdgeMap.containsKey(edge)) {
                this.outerEdgeMap.remove(edge);
                this.innerEdgeMap.put(edge, edge);
                continue;
            }
            if (this.nodeMap.containsKey(target) && this.nodeMap.containsKey(source)) {
                this.innerEdgeMap.put(edge, edge);
                continue;
            }
            if (!this.nodeMap.containsKey(target) && !this.nodeMap.containsKey(source)) continue;
            this.outerEdgeMap.put(edge, edge);
        }
        this.nodeToEdgeMap.put(node, edgeList);
        if (!node.inGroup(this)) {
            node.addToGroup(this);
        }
    }

    private void removeNodeFromGroup(CyNode node) {
        this.nodeMap.remove(node);
        RootGraph rg = node.getRootGraph();
        List<CyEdge> edgeArray = this.nodeToEdgeMap.get(node);
        for (CyEdge edge : edgeArray) {
            if (this.innerEdgeMap.containsKey(edge)) {
                this.innerEdgeMap.remove(edge);
                this.outerEdgeMap.put(edge, edge);
                continue;
            }
            if (!this.outerEdgeMap.containsKey(edge)) continue;
            this.outerEdgeMap.remove(edge);
        }
        this.nodeToEdgeMap.remove(node);
        if (node.inGroup(this)) {
            node.removeFromGroup(this);
        }
    }
}

