/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.writers;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.data.readers.XGMMLReader;
import cytoscape.data.writers.XGMMLWriter;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.URISyntaxException;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class XGMMLWriterTest
extends TestCase {
    public void testXGMMLWriterRoundTrip1() throws IOException, URISyntaxException {
        this.compareRoundTrip("testData/XGMMLWriterTestFile01a.xgmml", "testData/XGMMLWriterTestFile01b.xgmml");
    }

    public void testXGMMLWriterRoundTrip2aFullEncodingDefault() throws IOException, URISyntaxException {
        System.clearProperty("cytoscape.encode.xgmml.attributes");
        this.compareRoundTrip("testData/XGMMLWriterTestFile02a.xgmml", "testData/XGMMLWriterTestFile02a.xgmml");
    }

    public void testXGMMLWriterRoundTrip2aFullEncodingOn() throws IOException, URISyntaxException {
        System.setProperty("cytoscape.encode.xgmml.attributes", "true");
        this.compareRoundTrip("testData/XGMMLWriterTestFile02a.xgmml", "testData/XGMMLWriterTestFile02a.xgmml");
    }

    public void testXGMMLWriterRoundTrip2aFullEncodingOff() throws IOException, URISyntaxException {
        System.setProperty("cytoscape.encode.xgmml.attributes", "false");
        this.compareRoundTrip("testData/XGMMLWriterTestFile02a.xgmml", "testData/XGMMLWriterTestFile02a.xgmml");
    }

    public void testXGMMLWriterRoundTrip2bFullEncodingDefault() throws IOException, URISyntaxException {
        System.clearProperty("cytoscape.encode.xgmml.attributes");
        this.compareRoundTrip("testData/XGMMLWriterTestFile02b.xgmml", "testData/XGMMLWriterTestFile02a.xgmml");
    }

    public void testXGMMLWriterRoundTrip2bFullEncodingOn() throws IOException, URISyntaxException {
        System.setProperty("cytoscape.encode.xgmml.attributes", "true");
        this.compareRoundTrip("testData/XGMMLWriterTestFile02b.xgmml", "testData/XGMMLWriterTestFile02a.xgmml");
    }

    public void testXGMMLWriterRoundTrip2bFullEncodingOff() throws IOException, URISyntaxException {
        System.setProperty("cytoscape.encode.xgmml.attributes", "false");
        this.compareRoundTrip("testData/XGMMLWriterTestFile02b.xgmml", "testData/XGMMLWriterTestFile02a.xgmml");
    }

    public void testXGMMLWriterRoundTrip2cFullEncodingDefault() throws IOException, URISyntaxException {
        System.clearProperty("cytoscape.encode.xgmml.attributes");
        this.compareRoundTrip("testData/XGMMLWriterTestFile02c.xgmml", "testData/XGMMLWriterTestFile02d.xgmml");
    }

    public void testXGMMLWriterRoundTrip2cFullEncodingOn() throws IOException, URISyntaxException {
        System.setProperty("cytoscape.encode.xgmml.attributes", "true");
        this.compareRoundTrip("testData/XGMMLWriterTestFile02c.xgmml", "testData/XGMMLWriterTestFile02d.xgmml");
    }

    public void testXGMMLWriterRoundTrip2cFullEncodingOff() throws IOException, URISyntaxException {
        System.setProperty("cytoscape.encode.xgmml.attributes", "false");
        this.compareRoundTrip("testData/XGMMLWriterTestFile02c.xgmml", "testData/XGMMLWriterTestFile02c.xgmml");
    }

    public void testXGMMLWriterBug0001938() throws IOException, URISyntaxException {
        System.setProperty("cytoscape.encode.xgmml.attributes", "true");
        CyNetwork cn = Cytoscape.createNetwork("<\"aw&ward\name\tstring>\"");
        StringWriter sw = new StringWriter();
        XGMMLWriter w = new XGMMLWriter(cn, null);
        w.write(sw);
        sw.close();
        String xgmmls = sw.toString();
        System.out.println(xgmmls);
        ByteArrayInputStream bais = new ByteArrayInputStream(xgmmls.getBytes("US-ASCII"));
        XGMMLReader r = new XGMMLReader(bais);
        cn = Cytoscape.createNetwork(r, false, null);
    }

    private void compareRoundTrip(String fileIn, String fileToCompare) throws IOException, URISyntaxException {
        XGMMLReader r = new XGMMLReader(fileIn);
        CyNetwork cn = Cytoscape.createNetwork(r, false, null);
        StringWriter sw = new StringWriter();
        XGMMLWriter w = new XGMMLWriter(cn, null);
        w.write(sw);
        sw.close();
        String output = sw.toString();
        this.compareFilesByLine(fileToCompare, output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void compareFilesByLine(String fileToCompare, String output) throws IOException {
        StringBuilder sb;
        String[] linesGot;
        block12: {
            FileInputStream fis = null;
            for (String line : linesGot = output.split("\n")) {
                System.out.println(line);
            }
            sb = new StringBuilder();
            try {
                block11: {
                    InputStreamReader isr = null;
                    fis = new FileInputStream(fileToCompare);
                    try {
                        isr = new InputStreamReader((InputStream)fis, "UTF-8");
                        int c = isr.read();
                        while (c != -1) {
                            sb.append((char)c);
                            c = isr.read();
                        }
                        Object var14_14 = null;
                        if (isr == null) break block11;
                    }
                    catch (Throwable throwable) {
                        Object var14_15 = null;
                        if (isr != null) {
                            isr.close();
                        }
                        throw throwable;
                    }
                    isr.close();
                }
                Object var16_17 = null;
                if (fis == null) break block12;
            }
            catch (Throwable throwable) {
                Object var16_18 = null;
                if (fis != null) {
                    fis.close();
                }
                throw throwable;
            }
            fis.close();
        }
        String content = sb.toString();
        System.out.println("Read " + content.getBytes("UTF-8").length + " bytes");
        String[] linesExptd = content.split("\n");
        XGMMLWriterTest.assertTrue("XGMMLWriter: No. of lines, expect " + linesExptd.length + ", got" + linesGot.length, linesExptd.length == linesGot.length);
        int i = 0;
        while (i < linesExptd.length) {
            String exptd = linesExptd[i];
            String got = linesGot[i];
            if (!(exptd.contains("<dc:date>") || exptd.contains("<node") || exptd.contains("<edge"))) {
                System.out.println("Exp (" + exptd.length() + ")>" + exptd);
                System.out.println("Got (" + got.length() + ")>" + got);
                XGMMLWriterTest.assertEquals("Line " + i + " {" + got + "} {" + exptd + "}", exptd, got);
            }
            ++i;
        }
        return;
    }

    public static void main(String[] args) {
        TestRunner.run(XGMMLWriterTest.class);
    }
}

