/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.webservice.util;

import cytoscape.Cytoscape;
import cytoscape.CytoscapeInit;
import cytoscape.data.webservice.ui.UnifiedNetworkImportDialog;
import cytoscape.logger.CyLogger;
import cytoscape.plugin.Category;
import cytoscape.plugin.DownloadableInfo;
import cytoscape.plugin.ManagerException;
import cytoscape.plugin.ManagerUtil;
import cytoscape.plugin.PluginException;
import cytoscape.plugin.PluginManager;
import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;
import cytoscape.task.ui.JTaskConfig;
import cytoscape.task.util.TaskManager;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jdom.JDOMException;

public class WebServiceThemeInstall {
    public static final String WEBSERVICE_THEME = "WebServiceClientPack";
    private static CyLogger logger = CyLogger.getLogger(WebServiceThemeInstall.class);
    private PluginManager mgr;
    private UnifiedNetworkImportDialog unifiedNetworkImportDialog;

    public WebServiceThemeInstall(UnifiedNetworkImportDialog dialog) {
        this.unifiedNetworkImportDialog = dialog;
        this.mgr = PluginManager.getPluginManager();
    }

    protected WebServiceThemeInstall(PluginManager manager) {
        this.mgr = manager;
    }

    public DownloadableInfo installTheme() throws JDOMException, IOException {
        Map<String, List<DownloadableInfo>> DownloadableByCategory = ManagerUtil.sortByCategory(this.mgr.inquire(CytoscapeInit.getProperties().getProperty("defaultPluginDownloadUrl")));
        DownloadableInfo WSTheme = null;
        for (DownloadableInfo Theme : DownloadableByCategory.get(Category.THEME.toString())) {
            if (!Theme.getName().equals(WEBSERVICE_THEME) || !Theme.isPluginCompatibleWithCurrent()) continue;
            if (WSTheme == null) {
                WSTheme = Theme;
            }
            if (!Theme.isNewerObjectVersion(WSTheme)) continue;
            WSTheme = Theme;
        }
        return this.runInstallTask(WSTheme);
    }

    private DownloadableInfo runInstallTask(DownloadableInfo obj) {
        InstallTask task = new InstallTask(obj);
        JTaskConfig jTaskConfig = new JTaskConfig();
        jTaskConfig.setOwner(Cytoscape.getDesktop());
        jTaskConfig.displayCloseButton(false);
        jTaskConfig.displayStatus(true);
        jTaskConfig.setAutoDispose(true);
        jTaskConfig.displayCancelButton(true);
        TaskManager.executeTask(task, jTaskConfig);
        DownloadableInfo info = task.getDownloadedPlugin();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                WebServiceThemeInstall.this.unifiedNetworkImportDialog.resetGUI();
                JOptionPane.showMessageDialog(Cytoscape.getDesktop(), "Web Services Pack Successfully Installed.", "Installation Successfull", 1);
            }
        });
        return info;
    }

    private class InstallTask
    implements Task {
        private TaskMonitor taskMonitor;
        private DownloadableInfo infoObj;
        private String errorMsg;

        public InstallTask(DownloadableInfo Info2) throws IllegalArgumentException {
            String ErrorMsg = null;
            if (Info2 == null) {
                ErrorMsg = "DownloadableInfo object cannot be null\n";
                throw new IllegalArgumentException(ErrorMsg);
            }
            this.infoObj = Info2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            if (this.taskMonitor == null) {
                throw new IllegalStateException("Task Monitor is not set.");
            }
            this.taskMonitor.setStatus("Installing " + this.infoObj.getName() + " v" + this.infoObj.getObjectVersion());
            this.taskMonitor.setPercentCompleted(-1);
            PluginManager Mgr = PluginManager.getPluginManager();
            try {
                try {
                    this.infoObj = Mgr.download(this.infoObj, this.taskMonitor);
                    this.taskMonitor.setStatus(this.infoObj.getName() + " v" + this.infoObj.getObjectVersion() + " complete.");
                    this.taskMonitor.setStatus(this.infoObj.getName() + " v" + this.infoObj.getObjectVersion() + " loading...");
                    Mgr.install(this.infoObj);
                    Mgr.loadPlugin(this.infoObj);
                }
                catch (IOException ioe) {
                    this.taskMonitor.setException(ioe, "Failed to download " + this.infoObj.getName() + " from " + this.infoObj.getObjectUrl());
                    this.infoObj = null;
                    logger.warn("Failed to download " + this.infoObj.getName() + " from " + this.infoObj.getObjectUrl(), ioe);
                    Object var4_3 = null;
                    this.taskMonitor.setPercentCompleted(100);
                    return;
                }
                catch (ManagerException me) {
                    this.setErrorMessage("Failed to install " + this.infoObj.toString());
                    this.taskMonitor.setException(me, me.getMessage());
                    this.infoObj = null;
                    logger.warn("Failed to install " + this.infoObj.toString(), me);
                    Object var4_4 = null;
                    this.taskMonitor.setPercentCompleted(100);
                    return;
                }
                catch (PluginException pe) {
                    this.setErrorMessage("Failed to install " + this.infoObj.toString());
                    this.infoObj = null;
                    this.taskMonitor.setException(pe, pe.getMessage());
                    logger.warn("Failed to install " + this.infoObj.toString(), pe);
                    Object var4_5 = null;
                    this.taskMonitor.setPercentCompleted(100);
                    return;
                }
                catch (ClassNotFoundException cne) {
                    this.taskMonitor.setException(cne, cne.getMessage());
                    this.setErrorMessage("Failed to install " + this.infoObj.toString());
                    this.infoObj = null;
                    logger.warn("Failed to install " + this.infoObj.toString(), cne);
                    Object var4_6 = null;
                    this.taskMonitor.setPercentCompleted(100);
                    return;
                }
                Object var4_2 = null;
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                this.taskMonitor.setPercentCompleted(100);
                throw throwable;
            }
            this.taskMonitor.setPercentCompleted(100);
        }

        private void setErrorMessage(String em) {
            this.errorMsg = em;
        }

        public String getErrorMessage() {
            return this.errorMsg;
        }

        public DownloadableInfo getDownloadedPlugin() {
            return this.infoObj;
        }

        public void halt() {
        }

        public void setTaskMonitor(TaskMonitor monitor) throws IllegalThreadStateException {
            this.taskMonitor = monitor;
        }

        public String getTitle() {
            return "Installing Cytoscape Theme: '" + this.infoObj.getName() + "'";
        }
    }
}

