/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.webservice.util;

import cytoscape.Cytoscape;
import cytoscape.CytoscapeInit;
import cytoscape.data.webservice.CyWebServiceEvent;
import cytoscape.data.webservice.DatabaseSearchResult;
import cytoscape.data.webservice.NetworkImportWebServiceClient;
import cytoscape.data.webservice.WebServiceClient;
import cytoscape.data.webservice.WebServiceClientManager;
import cytoscape.layout.CyLayouts;
import cytoscape.logger.CyLogger;
import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;
import cytoscape.task.ui.JTaskConfig;
import cytoscape.task.util.TaskManager;
import giny.model.Node;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class NetworkExpansionMenu
implements PropertyChangeListener {
    private static final String LAYOUT_PROP = "expanderDefaultLayout";
    private static final String DEF_LAYOUT = "force-directed";
    private static NetworkExpansionMenu expander;
    private static CyLogger logger;
    private String defLayout;

    public static JMenuItem getExpander(WebServiceClient client) {
        return expander.getMenuItem(client);
    }

    public NetworkExpansionMenu() {
        Cytoscape.getPropertyChangeSupport().addPropertyChangeListener(this);
        this.defLayout = CytoscapeInit.getProperties().getProperty(LAYOUT_PROP);
        if (this.defLayout == null) {
            this.defLayout = DEF_LAYOUT;
        }
    }

    private JMenuItem getMenuItem(final WebServiceClient client) {
        JMenuItem expandMenu = new JMenuItem(new AbstractAction("Get neighbours by ID(s)"){

            public void actionPerformed(ActionEvent e) {
                logger.info("Start expanding network: " + e.getActionCommand());
                CyWebServiceEvent<String> evt = new CyWebServiceEvent<String>(client.getClientID(), CyWebServiceEvent.WSEventType.SEARCH_DATABASE, NetworkExpansionMenu.this.buildStringQuery(), CyWebServiceEvent.WSEventType.EXPAND_NETWORK);
                SearchTask task = new SearchTask(evt);
                JTaskConfig jTaskConfig = new JTaskConfig();
                jTaskConfig.setOwner(Cytoscape.getDesktop());
                jTaskConfig.displayCloseButton(true);
                jTaskConfig.displayStatus(true);
                jTaskConfig.setAutoDispose(true);
                TaskManager.executeTask(task, jTaskConfig);
            }
        });
        return expandMenu;
    }

    private String buildStringQuery() {
        StringBuilder builder = new StringBuilder();
        Set selectedNodes = Cytoscape.getCurrentNetwork().getSelectedNodes();
        for (Node node : selectedNodes) {
            builder.append(node.getIdentifier() + " ");
        }
        return builder.toString();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        Object resultObj = evt.getNewValue();
        if (evt.getPropertyName().equals(CyWebServiceEvent.WSResponseType.SEARCH_FINISHED.toString()) && ((DatabaseSearchResult)resultObj).getNextMove().equals((Object)CyWebServiceEvent.WSEventType.EXPAND_NETWORK)) {
            logger.info("Search result from " + evt.getSource() + ", Number of result = " + evt.getNewValue() + ", Source name = " + evt.getOldValue());
            String[] message = new String[]{((DatabaseSearchResult)resultObj).getResultSize() + " interactions found.", "Do you want to add new nodes and edges to " + Cytoscape.getCurrentNetwork().getTitle() + "?"};
            int value = JOptionPane.showConfirmDialog(Cytoscape.getDesktop(), message, "Expand network", 0);
            if (value == 0) {
                CyWebServiceEvent evt2 = new CyWebServiceEvent(evt.getOldValue().toString(), CyWebServiceEvent.WSEventType.EXPAND_NETWORK, ((DatabaseSearchResult)resultObj).getResult());
                try {
                    WebServiceClientManager.getCyWebServiceEventSupport().fireCyWebServiceEvent(evt2);
                }
                catch (Exception e) {
                    logger.warn("Exception handling web service event '" + evt2.toString() + "': ", e);
                }
            }
        } else if (evt.getPropertyName().equals("NETWORK_MODIFIED") && evt.getSource() instanceof NetworkImportWebServiceClient) {
            String[] message = new String[]{"Neighbours loaded.", "Do you want to layout the network now?"};
            int value = JOptionPane.showConfirmDialog(Cytoscape.getDesktop(), message, "Expansion complete", 0);
            if (value == 0) {
                CyLayouts.getLayout(this.defLayout).doLayout();
            }
        } else if (evt.getPropertyName().equals("PREFERENCES_UPDATED")) {
            this.defLayout = CytoscapeInit.getProperties().getProperty(LAYOUT_PROP);
            if (this.defLayout == null) {
                this.defLayout = DEF_LAYOUT;
            }
        }
    }

    static {
        logger = CyLogger.getLogger(NetworkExpansionMenu.class);
        expander = new NetworkExpansionMenu();
    }

    class SearchTask
    implements Task {
        private CyWebServiceEvent evt;
        private TaskMonitor taskMonitor;

        public SearchTask(CyWebServiceEvent evt) {
            this.evt = evt;
        }

        public String getTitle() {
            return "Expanding Network";
        }

        public void halt() {
        }

        public void run() {
            this.taskMonitor.setStatus("Loading neighbours...");
            this.taskMonitor.setPercentCompleted(-1);
            try {
                WebServiceClientManager.getCyWebServiceEventSupport().fireCyWebServiceEvent(this.evt);
            }
            catch (Exception e) {
                this.taskMonitor.setException(e, "Failed to load neighbours.");
                return;
            }
            this.taskMonitor.setPercentCompleted(100);
            Cytoscape.getDesktop().setFocus(Cytoscape.getCurrentNetwork().getIdentifier());
            String curNetID = Cytoscape.getCurrentNetwork().getIdentifier();
            Cytoscape.getNetworkView(curNetID).setVisualStyle(Cytoscape.getVisualMappingManager().getVisualStyle().getName());
            Cytoscape.getNetworkView(curNetID).redrawGraph(false, true);
        }

        public void setTaskMonitor(TaskMonitor arg0) throws IllegalThreadStateException {
            this.taskMonitor = arg0;
        }
    }
}

