/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.readers;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class FileImporterTest
extends TestCase {
    String location;
    String title;
    int nodeCount;
    int edgeCount;
    CyNetwork network;

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
    }

    public void testGMLImport() throws Exception {
        this.location = "testData/gal.gml";
        this.network = Cytoscape.createNetworkFromFile(this.location);
        this.title = this.network.getTitle();
        FileImporterTest.assertEquals("gal", this.title);
        this.nodeCount = this.network.getNodeCount();
        FileImporterTest.assertEquals("number of nodes", 11, this.nodeCount);
        this.edgeCount = this.network.getEdgeCount();
        FileImporterTest.assertEquals("number of edges", 10, this.edgeCount);
    }

    public void testXGMMLImport() throws Exception {
        this.location = "testData/galFiltered2.xgmml";
        this.network = Cytoscape.createNetworkFromFile(this.location, false);
        this.title = this.network.getTitle();
        FileImporterTest.assertEquals("GAL Filtered (Yeast)", this.title);
        this.nodeCount = this.network.getNodeCount();
        FileImporterTest.assertEquals("num nodes", 331, this.nodeCount);
        this.edgeCount = this.network.getEdgeCount();
        FileImporterTest.assertEquals("num edges", 362, this.edgeCount);
    }

    public void testSIFImport() throws Exception {
        this.location = "testData/galFiltered.sif";
        this.network = Cytoscape.createNetworkFromFile(this.location, false);
        this.title = this.network.getTitle();
        FileImporterTest.assertEquals("galFiltered", this.title);
        this.nodeCount = this.network.getNodeCount();
        FileImporterTest.assertEquals("num nodes", 331, this.nodeCount);
        this.edgeCount = this.network.getEdgeCount();
        FileImporterTest.assertEquals("num edge", 362, this.edgeCount);
    }

    public static void main(String[] args) {
        TestRunner.run(FileImporterTest.class);
    }
}

