/*
 * Decompiled with CFR 0.152.
 */
package cytoscape;

import cytoscape.logger.CyLogger;

class JavaVersion {
    private static JavaVersion theJavaVersion;
    private static final CyLogger logger;
    private int major;
    private int minor;
    private int maintenanceLevel;
    private int update;

    private JavaVersion() {
        String javaVersion = System.getProperty("java.version");
        int nonDigitPos = 0;
        while (Character.isDigit(javaVersion.charAt(nonDigitPos))) {
            ++nonDigitPos;
        }
        try {
            this.major = Integer.parseInt(javaVersion.substring(0, nonDigitPos));
        }
        catch (NumberFormatException e) {
            logger.error("Can't determine Java major version number from \"" + javaVersion + "\"!");
            this.major = 0;
        }
        int intStart = ++nonDigitPos;
        while (Character.isDigit(javaVersion.charAt(nonDigitPos))) {
            ++nonDigitPos;
        }
        try {
            this.minor = Integer.parseInt(javaVersion.substring(intStart, nonDigitPos));
        }
        catch (NumberFormatException e) {
            logger.error("Can't determine Java major version number from \"" + javaVersion + "\"!");
            this.minor = 0;
        }
        intStart = ++nonDigitPos;
        while (nonDigitPos < javaVersion.length() && Character.isDigit(javaVersion.charAt(nonDigitPos))) {
            ++nonDigitPos;
        }
        try {
            this.maintenanceLevel = Integer.parseInt(javaVersion.substring(intStart, nonDigitPos));
        }
        catch (NumberFormatException e) {
            logger.error("Can't determine Java maintenance level from \"" + javaVersion + "\"!");
            this.maintenanceLevel = 0;
        }
        intStart = ++nonDigitPos;
        while (nonDigitPos < javaVersion.length() && Character.isDigit(javaVersion.charAt(nonDigitPos))) {
            ++nonDigitPos;
        }
        if (nonDigitPos > javaVersion.length()) {
            this.update = 0;
        } else {
            try {
                this.update = Integer.parseInt(javaVersion.substring(intStart, nonDigitPos));
            }
            catch (NumberFormatException e) {
                logger.error("Can't determine Java update version number from \"" + javaVersion + "\"!");
                this.update = 0;
            }
        }
    }

    static synchronized JavaVersion getJavaVersion() {
        if (theJavaVersion == null) {
            theJavaVersion = new JavaVersion();
        }
        return theJavaVersion;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    int getMajor() {
        return this.major;
    }

    int getMinor() {
        return this.minor;
    }

    int getMaintenanceLevel() {
        return this.maintenanceLevel;
    }

    int getUpdate() {
        return this.update;
    }

    static {
        logger = CyLogger.getLogger(JavaVersion.class);
    }
}

