/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glf.util;

import com.sun.glf.util.FontPreview;
import com.sun.glf.util.GridBagPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.TextAttribute;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class FontChooser {
    static final String REGULAR = "Regular";
    static final String ITALIC = "Italic";
    static final String BOLD = "Bold";
    static final String FONT_CHOOSER = "Font Chooser";
    static final String FONT_NAME = "Name: ";
    static final String FONT_STYLE = "Style";
    static final String FONT_SIZE = "Size: ";
    static final String ERROR_INVALID_FONT_SIZE = "Error: invalid font size : should be a number";
    static final String OK = "OK";
    static final String CANCEL = "Cancel";
    static final String LOADING_FONTS_PLEASE_WAIT = "Loading fonts, please wait";
    static String[] fontNames;
    static Hashtable fontMap;
    static JCheckBox bold;
    static JCheckBox italic;
    static String[] fontSizes;
    static JDialog dialog;
    static JList fontList;
    static JComboBox fontSize;
    static FontPreview preview;
    static Font retVal;
    static final Font defaultFont;
    static LoadMonitor loadMonitor;
    private static Font[] allFonts;

    FontChooser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadFontsBackground() {
        if (!FontChooser.loadMonitor.loaded && !FontChooser.loadMonitor.loading) {
            boolean bl = false;
            Object object = loadMonitor;
            synchronized (object) {
                if (!FontChooser.loadMonitor.loading) {
                    FontChooser.loadMonitor.loading = true;
                    bl = true;
                }
            }
            if (bl) {
                object = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Object object;
                        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
                        FontChooser.access$002(graphicsEnvironment.getAllFonts());
                        int n = allFonts != null ? allFonts.length : 0;
                        fontNames = new String[n];
                        fontMap = new Hashtable();
                        String string = "";
                        int n2 = 0;
                        for (int i = 0; i < n; ++i) {
                            object = allFonts[i];
                            if (string.equals(((Font)object).getFamily())) continue;
                            FontChooser.fontNames[n2] = string = ((Font)object).getFamily();
                            fontMap.put(string, object);
                            ++n2;
                        }
                        String[] stringArray = fontNames;
                        fontNames = new String[n2];
                        System.arraycopy(stringArray, 0, fontNames, 0, n2);
                        object = loadMonitor;
                        synchronized (object) {
                            FontChooser.loadMonitor.loaded = true;
                            FontChooser.loadMonitor.loading = false;
                            loadMonitor.notifyAll();
                        }
                    }
                };
                ((Thread)object).setPriority(Thread.currentThread().getPriority() - 1);
                ((Thread)object).start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void buildDialog() {
        Object object;
        JComponent jComponent;
        JDialog jDialog = new JDialog((Frame)null, FONT_CHOOSER, false);
        if (!FontChooser.loadMonitor.loaded) {
            jComponent = new JLabel(LOADING_FONTS_PLEASE_WAIT);
            jDialog.getContentPane().add(jComponent);
            jComponent.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5))));
            jComponent.setFont(new Font("Dialog", 0, 32));
            jDialog.pack();
            jDialog.setVisible(true);
            jDialog.paint(jDialog.getGraphics());
            jDialog.setCursor(Cursor.getPredefinedCursor(3));
            FontChooser.loadFontsBackground();
            object = loadMonitor;
            synchronized (object) {
                if (!FontChooser.loadMonitor.loaded) {
                    FontChooser.loadFontsBackground();
                    try {
                        loadMonitor.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        jDialog.setVisible(false);
        if (!FontChooser.loadMonitor.loaded) {
            throw new Error();
        }
        dialog = new JDialog((Frame)null, FONT_CHOOSER, true);
        fontList = new JList<String>(fontNames);
        bold = new JCheckBox(BOLD);
        italic = new JCheckBox(ITALIC);
        fontSize = new JComboBox<String>(fontSizes);
        fontSize.setEditable(true);
        preview = new FontPreview(defaultFont, false);
        jComponent = new GridBagPanel();
        ((GridBagPanel)jComponent).add(bold, 0, 0, 1, 1, 17, 0, 0.0, 0.0);
        ((GridBagPanel)jComponent).add(italic, 0, 1, 1, 1, 17, 0, 0.0, 0.0);
        fontList.setVisibleRowCount(5);
        preview.setPreferredSize(new Dimension(200, 50));
        object = new GridBagPanel();
        GridBagPanel gridBagPanel = new GridBagPanel();
        gridBagPanel.add(preview, 0, 0, 1, 1, 10, 1, 1.0, 1.0);
        GridBagPanel gridBagPanel2 = new GridBagPanel();
        gridBagPanel2.add(new JLabel(FONT_NAME), 0, 0, 1, 1, 17, 0, 0.0, 0.0);
        gridBagPanel2.add(new JScrollPane(fontList, 20, 30), 0, 1, 1, 1, 10, 0, 0.0, 0.0);
        ((GridBagPanel)object).add(gridBagPanel2, 0, 0, 1, 2, 17, 0, 0.0, 0.0);
        ((GridBagPanel)object).add(new JLabel(FONT_SIZE), 1, 0, 1, 1, 17, 0, 0.0, 0.0);
        ((GridBagPanel)object).add(fontSize, 2, 0, 1, 1, 17, 2, 0.0, 0.0);
        ((GridBagPanel)object).add(Box.createHorizontalGlue(), 3, 0, 1, 1, 17, 2, 1.0, 0.0);
        ((GridBagPanel)object).add(jComponent, 1, 1, 2, 1, 18, 2, 0.0, 0.0);
        ((GridBagPanel)object).add(gridBagPanel, 0, 3, 0, 1, 10, 1, 1.0, 1.0);
        JPanel jPanel = new JPanel(new GridLayout(1, 0));
        JButton jButton = new JButton(OK);
        JButton jButton2 = new JButton(CANCEL);
        jPanel.add(jButton);
        jPanel.add(jButton2);
        GridBagPanel gridBagPanel3 = new GridBagPanel();
        gridBagPanel3.add(Box.createHorizontalGlue(), 0, 0, 1, 1, 13, 2, 1.0, 0.0);
        gridBagPanel3.add(jPanel, 0, 0, 1, 1, 13, 0, 0.0, 0.0);
        ((JComponent)object).setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5))));
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        gridBagPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        jComponent.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), FONT_STYLE, 1, 2));
        Container container = dialog.getContentPane();
        container.removeAll();
        container.setLayout(new BorderLayout());
        container.add("Center", (Component)object);
        container.add("South", gridBagPanel3);
        dialog.pack();
        fontList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                FontChooser.onFontChange();
            }
        });
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FontChooser.onFontChange();
            }
        };
        bold.addActionListener(actionListener);
        italic.addActionListener(actionListener);
        fontSize.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FontChooser.onFontChange();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                retVal = null;
                dialog.dispose();
            }
        });
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                retVal = preview.getFont();
                dialog.dispose();
            }
        });
        dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                dialog.setVisible(false);
                dialog.dispose();
            }
        });
        dialog.setCursor(Cursor.getPredefinedCursor(0));
    }

    public static Font showDialog(String string, Font font) {
        if (dialog == null) {
            FontChooser.buildDialog();
        }
        dialog.setTitle(string);
        if (font == null) {
            font = defaultFont;
        }
        String string2 = FontChooser.bindName(font.getFamily());
        fontList.setSelectedValue(string2, true);
        String string3 = "" + font.getSize();
        fontSize.setSelectedItem(string3);
        bold.setSelected(font.isBold());
        italic.setSelected(font.isItalic());
        preview.setFont(font);
        dialog.show();
        return retVal;
    }

    private static String bindName(String string) {
        if (fontMap.get(string) == null) {
            string = fontNames[0];
        }
        return string;
    }

    private static void onFontChange() {
        if (dialog.isVisible()) {
            try {
                int n = fontList.getMinSelectionIndex();
                int n2 = Integer.parseInt((String)fontSize.getSelectedItem());
                Font font = (Font)fontMap.get(fontNames[n]);
                font = FontChooser.newFont(fontNames[n], n2 + 1);
                preview.setFont(font);
                font = FontChooser.newFont(fontNames[n], n2);
                preview.setFont(font);
                preview.repaint();
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(null, ERROR_INVALID_FONT_SIZE);
                fontSize.requestFocus();
            }
        }
    }

    private static Font newFont(String string, int n) {
        Font font = (Font)fontMap.get(string);
        Hashtable<TextAttribute, Object> hashtable = new Hashtable<TextAttribute, Object>();
        hashtable.put(TextAttribute.FAMILY, font.getFamily());
        hashtable.put(TextAttribute.SIZE, new Float(n));
        if (bold.isSelected()) {
            hashtable.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        } else {
            hashtable.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_REGULAR);
        }
        if (italic.isSelected()) {
            hashtable.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        } else {
            hashtable.put(TextAttribute.POSTURE, TextAttribute.POSTURE_REGULAR);
        }
        Font font2 = new Font(hashtable);
        return font2;
    }

    static /* synthetic */ Font[] access$002(Font[] fontArray) {
        allFonts = fontArray;
        return fontArray;
    }

    static {
        fontSizes = new String[]{"8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24", "26", "28", "32", "36", "48", "72"};
        defaultFont = new Font("Dialog", 0, 12);
        loadMonitor = new LoadMonitor();
    }

    static class LoadMonitor {
        boolean loaded;
        boolean loading;

        LoadMonitor() {
        }
    }
}

