/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glf.goodies;

import com.sun.glf.FillRenderer;
import com.sun.glf.Layer;
import com.sun.glf.LayerComposition;
import com.sun.glf.Renderer;
import com.sun.glf.ShapeLayer;
import com.sun.glf.StrokeRenderer;
import com.sun.glf.goodies.GradientPaintExtContext;
import com.sun.glf.util.CompositionComponent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class GradientPaintExt
implements Paint {
    private Point2D.Float start;
    private Point2D.Float end;
    private float[] I;
    private Color[] colors;
    private int transparency;
    private boolean cyclic;

    public Color[] getColors() {
        Color[] colorArray = new Color[this.colors.length];
        System.arraycopy(this.colors, 0, colorArray, 0, this.colors.length);
        return colorArray;
    }

    public float[] getIntervals() {
        float[] fArray = new float[this.I.length];
        System.arraycopy(this.I, 0, fArray, 0, this.I.length);
        return fArray;
    }

    public boolean isCyclic() {
        return this.cyclic;
    }

    public Point2D getStart() {
        return (Point2D)this.start.clone();
    }

    public Point2D getEnd() {
        return (Point2D)this.end.clone();
    }

    public GradientPaintExt(float f, float f2, float f3, float f4, float[] fArray, Color[] colorArray) {
        this(f, f2, f3, f4, fArray, colorArray, false);
    }

    public GradientPaintExt(float f, float f2, float f3, float f4, float[] fArray, Color[] colorArray, boolean bl) {
        this(new Point2D.Float(f, f2), new Point2D.Float(f3, f4), fArray, colorArray, bl);
    }

    public GradientPaintExt(Point2D point2D, Point2D point2D2, float[] fArray, Color[] colorArray) {
        this(point2D, point2D2, fArray, colorArray, false);
    }

    public GradientPaintExt(Point2D point2D, Point2D point2D2, float[] fArray, Color[] colorArray, boolean bl) {
        int n;
        if (point2D == null || point2D2 == null || point2D.equals(point2D2) || fArray == null || colorArray == null || fArray.length != colorArray.length - 1 || colorArray.length < 2) {
            throw new IllegalArgumentException();
        }
        this.cyclic = bl;
        this.start = new Point2D.Float((float)point2D.getX(), (float)point2D.getY());
        this.end = new Point2D.Float((float)point2D2.getX(), (float)point2D2.getY());
        float[] fArray2 = new float[fArray.length];
        System.arraycopy(fArray, 0, fArray2, 0, fArray.length);
        fArray = fArray2;
        float f = 0.0f;
        for (n = 0; n < fArray.length; ++n) {
            if (fArray[n] <= 0.0f) {
                throw new IllegalArgumentException("Cannot use negative or null interval: " + fArray[n]);
            }
            f += fArray[n];
        }
        n = 0;
        while (n < fArray.length) {
            int n2 = n++;
            fArray[n2] = fArray[n2] / f;
        }
        this.I = fArray;
        this.colors = new Color[colorArray.length];
        System.arraycopy(colorArray, 0, this.colors, 0, colorArray.length);
        n = 1;
        for (int i = 0; i < colorArray.length; ++i) {
            n = n != 0 && colorArray[i].getAlpha() == 255 ? 1 : 0;
        }
        this.transparency = n != 0 ? 1 : 3;
    }

    public PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
        try {
            return new GradientPaintExtContext(this.start, this.end, this.I, this.colors, affineTransform, this.cyclic);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            noninvertibleTransformException.printStackTrace();
            throw new IllegalArgumentException();
        }
    }

    public int getTransparency() {
        return this.transparency;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("GradientPaintExt unit testing");
        jFrame.getContentPane().setBackground(Color.white);
        jFrame.getContentPane().setLayout(new GridLayout(0, 2));
        Rectangle rectangle = new Rectangle(20, 20, 160, 60);
        Dimension dimension = new Dimension(200, 100);
        Color[] colorArray = new Color[]{Color.black, Color.white, Color.orange, Color.white, Color.yellow, Color.red};
        float[] fArray = new float[]{2.0f, 2.0f, 3.0f, 4.0f, 3.0f};
        GradientPaintExt gradientPaintExt = new GradientPaintExt(60.0f, 20.0f, 100.0f, 60.0f, fArray, colorArray, false);
        GradientPaintExt gradientPaintExt2 = new GradientPaintExt(60.0f, 20.0f, 100.0f, 60.0f, fArray, colorArray, true);
        FillRenderer fillRenderer = new FillRenderer(gradientPaintExt);
        FillRenderer fillRenderer2 = new FillRenderer(gradientPaintExt2);
        AffineTransform affineTransform = null;
        jFrame.getContentPane().add(GradientPaintExt.makeNewComponent(dimension, rectangle, fillRenderer, affineTransform, "Non-cyclic, no transform"));
        jFrame.getContentPane().add(GradientPaintExt.makeNewComponent(dimension, rectangle, fillRenderer2, affineTransform, "Cyclic, no transform"));
        affineTransform = AffineTransform.getTranslateInstance(40.0, 40.0);
        affineTransform.rotate(Math.PI, 100.0, 50.0);
        jFrame.getContentPane().add(GradientPaintExt.makeNewComponent(dimension, rectangle, fillRenderer, affineTransform, "Non-cyclic, translation & Flip"));
        jFrame.getContentPane().add(GradientPaintExt.makeNewComponent(dimension, rectangle, fillRenderer2, affineTransform, "Cyclic, translation & Flip"));
        affineTransform = AffineTransform.getScaleInstance(2.0, 2.0);
        jFrame.getContentPane().add(GradientPaintExt.makeNewComponent(dimension, rectangle, fillRenderer, affineTransform, "Non-cyclic, scale"));
        jFrame.getContentPane().add(GradientPaintExt.makeNewComponent(dimension, rectangle, fillRenderer2, affineTransform, "Cyclic, scale"));
        affineTransform = AffineTransform.getRotateInstance(0.7853981633974483, 100.0, 50.0);
        affineTransform.rotate(Math.PI, 100.0, 50.0);
        jFrame.getContentPane().add(GradientPaintExt.makeNewComponent(dimension, rectangle, fillRenderer, affineTransform, "Non-cyclic, rotation"));
        jFrame.getContentPane().add(GradientPaintExt.makeNewComponent(dimension, rectangle, fillRenderer2, affineTransform, "Cyclic, rotation"));
        affineTransform = AffineTransform.getShearInstance(0.5, 0.0);
        jFrame.getContentPane().add(GradientPaintExt.makeNewComponent(dimension, rectangle, fillRenderer, affineTransform, "Non-cyclic, shear"));
        jFrame.getContentPane().add(GradientPaintExt.makeNewComponent(dimension, rectangle, fillRenderer2, affineTransform, "Cyclic, shear"));
        jFrame.pack();
        jFrame.setVisible(true);
    }

    private static JComponent makeNewComponent(Dimension dimension, Shape shape, Renderer renderer, AffineTransform affineTransform, String string) {
        LayerComposition layerComposition = new LayerComposition(dimension);
        Rectangle rectangle = new Rectangle(-1, -1, dimension.width, dimension.height);
        ShapeLayer shapeLayer = new ShapeLayer(layerComposition, shape, renderer);
        shapeLayer.setTransform(affineTransform);
        ShapeLayer shapeLayer2 = new ShapeLayer(layerComposition, rectangle, new StrokeRenderer((Paint)Color.black, 1.0f));
        layerComposition.setLayers(new Layer[]{shapeLayer, shapeLayer2});
        CompositionComponent compositionComponent = new CompositionComponent(layerComposition);
        compositionComponent.setToolTipText(string);
        return compositionComponent;
    }
}

