/*
 * Decompiled with CFR 0.152.
 */
package com.sosnoski.util.hashmap;

import com.sosnoski.util.hashmap.ObjectKeyBase;

public class ObjectIntHashMap
extends ObjectKeyBase {
    public static final int DEFAULT_NOT_FOUND = Integer.MIN_VALUE;
    protected Object[] m_keyTable;
    protected int[] m_valueTable;
    protected int m_notFoundValue;
    static /* synthetic */ Class class$java$lang$Object;

    public ObjectIntHashMap(int n, double d, int n2, Object object) {
        super(n, d, class$java$lang$Object == null ? (class$java$lang$Object = ObjectIntHashMap.class$("java.lang.Object")) : class$java$lang$Object, Integer.TYPE, object);
        this.m_notFoundValue = n2;
    }

    public ObjectIntHashMap(int n, double d) {
        this(n, d, Integer.MIN_VALUE, (Object)"base");
    }

    public ObjectIntHashMap(int n, Object object) {
        this(n, 0.3, Integer.MIN_VALUE, object);
    }

    public ObjectIntHashMap(int n) {
        this(n, 0.3);
    }

    public ObjectIntHashMap(Object object) {
        this(0, 0.3, Integer.MIN_VALUE, object);
    }

    public ObjectIntHashMap() {
        this(0, 0.3);
    }

    public ObjectIntHashMap(ObjectIntHashMap objectIntHashMap) {
        super(objectIntHashMap);
        this.m_notFoundValue = objectIntHashMap.m_notFoundValue;
    }

    protected final Object[] getKeyArray() {
        return this.m_keyTable;
    }

    protected final void setKeyArray(Object object) {
        this.m_keyTable = (Object[])object;
    }

    protected final Object getValueArray() {
        return this.m_valueTable;
    }

    protected final void setValueArray(Object object) {
        this.m_valueTable = (int[])object;
    }

    protected final boolean reinsert(int n) {
        Object object = this.m_keyTable[n];
        this.m_keyTable[n] = null;
        return this.assignSlot(object, this.m_valueTable[n]) != n;
    }

    protected void restructure(Object object, Object object2) {
        Object[] objectArray = (Object[])object;
        int[] nArray = (int[])object2;
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] != null) {
                this.assignSlot(objectArray[n], nArray[n]);
            }
            ++n;
        }
    }

    protected int assignSlot(Object object, int n) {
        int n2 = this.freeSlot(this.standardSlot(object));
        this.m_keyTable[n2] = object;
        this.m_valueTable[n2] = n;
        return n2;
    }

    public int add(Object object, int n) {
        if (object == null) {
            throw new IllegalArgumentException("null key not supported");
        }
        if (n == this.m_notFoundValue) {
            throw new IllegalArgumentException("value matching not found return not supported");
        }
        this.ensureCapacity(this.m_entryCount + 1);
        int n2 = this.standardFind(object);
        if (n2 >= 0) {
            int n3 = this.m_valueTable[n2];
            this.m_valueTable[n2] = n;
            return n3;
        }
        ++this.m_entryCount;
        n2 = -n2 - 1;
        this.m_keyTable[n2] = object;
        this.m_valueTable[n2] = n;
        return this.m_notFoundValue;
    }

    public final boolean containsKey(Object object) {
        return this.standardFind(object) >= 0;
    }

    public final int get(Object object) {
        int n = this.standardFind(object);
        if (n >= 0) {
            return this.m_valueTable[n];
        }
        return this.m_notFoundValue;
    }

    public int remove(Object object) {
        int n = this.standardFind(object);
        if (n >= 0) {
            int n2 = this.m_valueTable[n];
            this.internalRemove(n);
            return n2;
        }
        return this.m_notFoundValue;
    }

    public Object clone() {
        return new ObjectIntHashMap(this);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

