/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer;

import com.install4j.api.Util;
import com.install4j.api.beans.ReplacementMode;
import com.install4j.api.windows.WinFileSystem;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.VariableEncoding;
import com.install4j.runtime.installer.platform.macos.VolumeInfo;
import com.install4j.runtime.util.StringUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;

public class InstallerVariables {
    private static final String I18N_PREFIX = "i18n:";
    private static Map props = new TreeMap();
    private static Map variableProviders = new HashMap();
    private static Set responseFileVariables = new HashSet();
    private static boolean replaceInstallerVariables = false;
    private static boolean replaceI18nVariables = false;
    private static ResourceBundle overriddenResourceBundle;
    private static DesignTimeVariableProcessor designTimeVariableProcessor;
    public static final String INSTALLER_PREFIX = "installer:";
    public static final String VARIABLE_USER_HOME = "sys.userHome";
    public static final String VARIABLE_WINDOWS_DIR = "sys.windowsDir";
    public static final String VARIABLE_SYSTEM32_DIR = "sys.system32Dir";
    public static final String VARIABLE_PROGRAM_FILES_DIR = "sys.programFilesDir";
    public static final String VARIABLE_INSTALLATION_DIR = "sys.installationDir";
    public static final String VARIABLE_PROGRAM_GROUP_DIR = "sys.programGroupDir";
    public static final String VARIABLE_MEDIA_FILE = "sys.mediaFile";
    public static final String VARIABLE_MEDIA_DIR = "sys.mediaDirectory";
    private static final String VARIABLE_INSTALLER_FILE = "sys.installerFile";
    private static final String VARIABLE_INSTALLER_DIR = "sys.installerDirectory";
    private static final String VARFILE_SUFFIX = ".varfile";
    public static final String VARIABLE_LANGUAGE_ID = "sys.languageId";
    public static final String VARIABLE_LOGFILE = "sys.logFile";
    private static final StringUtil.ReplacementCallback PLAIN_CALLBACK;
    private static final StringUtil.ReplacementCallback REGEXP_MATCH_CALLBACK;
    private static final StringUtil.ReplacementCallback REGEXP_REPLACEMENT_CALLBACK;

    public static void setOverriddenResourceBundle(ResourceBundle resourceBundle) {
        overriddenResourceBundle = resourceBundle;
    }

    public static void setDesignTimeVariableProcessor(DesignTimeVariableProcessor designTimeVariableProcessor) {
        InstallerVariables.designTimeVariableProcessor = designTimeVariableProcessor;
    }

    private static String quoteRegexpSearch(String string) {
        int n = string.indexOf("\\E");
        if (n == -1) {
            return "\\Q" + string + "\\E";
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
        stringBuffer.append("\\Q");
        int n2 = 0;
        while ((n = string.indexOf("\\E", n2)) != -1) {
            stringBuffer.append(string.substring(n2, n));
            n2 = n + 2;
            stringBuffer.append("\\E\\\\E\\Q");
        }
        stringBuffer.append(string.substring(n2, string.length()));
        stringBuffer.append("\\E");
        return stringBuffer.toString();
    }

    private static String quoteRegexpReplacement(String string) {
        if (string.indexOf(92) == -1 && string.indexOf(36) == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\\') {
                stringBuffer.append('\\');
                stringBuffer.append('\\');
                continue;
            }
            if (c == '$') {
                stringBuffer.append('\\');
                stringBuffer.append('$');
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private static ResourceBundle getResourceBundle() {
        if (overriddenResourceBundle != null) {
            return overriddenResourceBundle;
        }
        return Messages.getMessages();
    }

    private static Object[] getArguments(String string) {
        ArrayList arrayList = new ArrayList();
        StringUtil.splitupQuotedList(arrayList, string, ",");
        ListIterator<Object> listIterator = arrayList.listIterator();
        while (listIterator.hasNext()) {
            String string2 = (String)listIterator.next();
            if (string2.startsWith("\"") && string2.endsWith("\"")) {
                string2 = string2.substring(1, string2.length() - 1);
                listIterator.set(string2);
                continue;
            }
            try {
                int n = Integer.parseInt(string2);
                listIterator.set(new Integer(n));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static boolean getBooleanVariable(String string) {
        return Boolean.valueOf(InstallerVariables.getStringVariable(string));
    }

    public static String getStringVariable(String string) {
        Object object = InstallerVariables.getVariable(string);
        return object == null ? null : object.toString();
    }

    public static Object getVariable(String string) {
        VariableProvider variableProvider = (VariableProvider)variableProviders.get(string);
        if (variableProvider != null) {
            return variableProvider.getVariable();
        }
        return props.get(string);
    }

    public static void setVariable(String string, Object object) {
        VariableProvider variableProvider = (VariableProvider)variableProviders.get(string);
        if (variableProvider != null) {
            variableProvider.setVariable(object);
        } else {
            props.put(string, object);
        }
    }

    public static void registerVariableProvider(String string, VariableProvider variableProvider) {
        variableProviders.put(string, variableProvider);
    }

    public static void setReplaceInstallerVariables(boolean bl) {
        replaceInstallerVariables = bl;
    }

    public static void setReplaceI18nVariables(boolean bl) {
        replaceI18nVariables = bl;
    }

    public static String replaceVariables(String string) {
        return InstallerVariables.replaceVariables(string, ReplacementMode.PLAIN);
    }

    public static String replaceVariables(String string, ReplacementMode replacementMode) {
        if (replaceInstallerVariables || replaceI18nVariables) {
            if (string == null) {
                return null;
            }
            if (designTimeVariableProcessor != null) {
                string = designTimeVariableProcessor.replaceDesignTimeVariables(string);
            }
            return StringUtil.replaceVariable(string, "${", "}", InstallerVariables.getCallback(replacementMode));
        }
        return string;
    }

    private static StringUtil.ReplacementCallback getCallback(ReplacementMode replacementMode) {
        if (replacementMode == ReplacementMode.REGEXP_MATCH) {
            return REGEXP_MATCH_CALLBACK;
        }
        if (replacementMode == ReplacementMode.REGEXP_REPLACEMENT) {
            return REGEXP_REPLACEMENT_CALLBACK;
        }
        return PLAIN_CALLBACK;
    }

    public static File replaceVariables(File file) {
        if (replaceInstallerVariables || replaceI18nVariables) {
            if (file == null) {
                return null;
            }
            return new File(InstallerVariables.replaceVariables(file.getPath()));
        }
        return file;
    }

    public static Set getVariableNames() {
        HashSet hashSet = new HashSet();
        hashSet.addAll(props.keySet());
        hashSet.addAll(variableProviders.keySet());
        return hashSet;
    }

    public static void init(String string, Properties properties) {
        block13: {
            Object object;
            Object object2;
            int n;
            File file;
            props.put(VARIABLE_USER_HOME, System.getProperty("user.home"));
            String string2 = System.getProperty("exe4j.moduleName");
            if (string2 != null) {
                File file2 = new File(string2);
                file = InstallerVariables.getMediaFile(file2);
                props.put(VARIABLE_MEDIA_FILE, file.getAbsolutePath());
                props.put(VARIABLE_MEDIA_DIR, file.getParentFile().getAbsolutePath());
                props.put(VARIABLE_INSTALLER_FILE, file2.getAbsolutePath());
                props.put(VARIABLE_INSTALLER_DIR, file2.getParentFile().getAbsolutePath());
            } else {
                props.put(VARIABLE_MEDIA_DIR, new File(System.getProperty("user.dir")).getAbsolutePath());
                props.put(VARIABLE_INSTALLER_DIR, new File(System.getProperty("user.dir")).getAbsolutePath());
            }
            if (InstallerUtil.isWindows()) {
                try {
                    props.put(VARIABLE_SYSTEM32_DIR, WinFileSystem.getSystemDirectory().getAbsolutePath());
                    props.put(VARIABLE_PROGRAM_FILES_DIR, WinFileSystem.getProgramFilesDirectory().getAbsolutePath());
                    props.put(VARIABLE_WINDOWS_DIR, WinFileSystem.getWindowsDirectory().getAbsolutePath());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            boolean bl = true;
            if (string == null && string2 != null && (n = string2.lastIndexOf(46)) > -1) {
                object2 = new File(string2.substring(0, n) + VARFILE_SUFFIX);
                if (((File)object2).exists() && ((File)object2).isFile()) {
                    string = ((File)object2).getPath();
                    bl = false;
                }
                if (string == null && (object = (String)props.get(VARIABLE_MEDIA_FILE)) != null && (n = ((String)object).lastIndexOf(46)) > -1 && ((File)(object2 = new File(((String)object).substring(0, n) + VARFILE_SUFFIX))).exists() && ((File)object2).isFile()) {
                    string = ((File)object2).getPath();
                    bl = false;
                }
            }
            if (string != null) {
                file = new File(string);
                if (!file.isAbsolute()) {
                    file = new File((String)props.get(VARIABLE_MEDIA_DIR), string);
                }
                try {
                    object2 = new BufferedInputStream(new FileInputStream(file.getAbsoluteFile()));
                    object = new Properties();
                    ((Properties)object).load((InputStream)object2);
                    InstallerVariables.addCommandLineVariables((Properties)object);
                }
                catch (IOException iOException) {
                    if (!bl) break block13;
                    System.err.println("Could not read file " + file.getAbsolutePath());
                    System.exit(1);
                }
            }
        }
        if (properties != null) {
            InstallerVariables.addCommandLineVariables(properties);
        }
    }

    private static File getMediaFile(File file) {
        String string;
        Map map;
        if (Util.isMacOS() && file != null && (map = VolumeInfo.getMountPointToDiskFile()) != null && (string = (String)map.get(file.getParentFile().getAbsolutePath())) != null) {
            return new File(string);
        }
        return file;
    }

    private static void addCommandLineVariables(Properties properties) {
        Map map = VariableEncoding.decodeVariables(properties);
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            InstallerVariables.setVariable((String)entry.getKey(), entry.getValue());
        }
    }

    public static void registerResponseFileVariable(String string) {
        responseFileVariables.add(string);
    }

    public static void writeResponseFile(File file, String[] stringArray) throws IOException {
        HashSet<String> hashSet = new HashSet<String>();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                hashSet.add(stringArray[i]);
            }
        }
        Properties properties = new Properties();
        Object object = responseFileVariables.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            if (hashSet.contains(string)) continue;
            Object object2 = InstallerVariables.getVariable(string);
            VariableEncoding.encodeVariable(properties, string, object2);
        }
        object = new BufferedOutputStream(new FileOutputStream(file));
        properties.store((OutputStream)object, "install4j response file for " + InstallerConfig.getCurrentInstance().getApplicationNameWithVersion());
        ((OutputStream)object).close();
    }

    static {
        PLAIN_CALLBACK = new InstallerReplacementCallback();
        REGEXP_MATCH_CALLBACK = new StringUtil.ReplacementCallback(){

            public String getReplacement(String string) {
                return InstallerVariables.quoteRegexpSearch(PLAIN_CALLBACK.getReplacement(string));
            }
        };
        REGEXP_REPLACEMENT_CALLBACK = new StringUtil.ReplacementCallback(){

            public String getReplacement(String string) {
                return InstallerVariables.quoteRegexpReplacement(PLAIN_CALLBACK.getReplacement(string));
            }
        };
    }

    private static class InstallerReplacementCallback
    implements StringUtil.ReplacementCallback {
        private InstallerReplacementCallback() {
        }

        public String getReplacement(String string) {
            if (string.startsWith(InstallerVariables.I18N_PREFIX) && replaceI18nVariables) {
                String string2;
                String string3 = string.substring(InstallerVariables.I18N_PREFIX.length());
                Object[] objectArray = null;
                int n = string3.indexOf(40);
                if (n > 0 && string3.endsWith(")")) {
                    string2 = string3.substring(n + 1, string3.length() - 1);
                    objectArray = InstallerVariables.getArguments(string2);
                    string3 = string3.substring(0, n);
                }
                try {
                    string2 = InstallerVariables.getResourceBundle().getString(string3);
                    if (objectArray == null) {
                        return string2;
                    }
                    return MessageFormat.format(string2, objectArray);
                }
                catch (MissingResourceException missingResourceException) {
                    return "ERROR: Unresolved i18n key \"" + string3 + "\"";
                }
            }
            if (string.startsWith(InstallerVariables.INSTALLER_PREFIX) && replaceInstallerVariables) {
                String string4 = string.substring(InstallerVariables.INSTALLER_PREFIX.length());
                String string5 = InstallerVariables.getStringVariable(string4);
                if (string5 == null) {
                    throw new UndefinedVariableException(string);
                }
                return string5;
            }
            return null;
        }
    }

    public static interface VariableProvider {
        public Object getVariable();

        public void setVariable(Object var1);
    }

    public static interface DesignTimeVariableProcessor {
        public String replaceDesignTimeVariables(String var1);
    }

    public static class UndefinedVariableException
    extends RuntimeException {
        private UndefinedVariableException(String string) {
            super(string);
        }
    }
}

