### R code from vignette source 'Cardinal-walkthrough.Rnw'

###################################################
### code chunk number 1: Cardinal-walkthrough.Rnw:10-11
###################################################
BiocStyle::latex()


###################################################
### code chunk number 2: Cardinal-walkthrough.Rnw:27-31
###################################################
library(Cardinal)
options(Cardinal.verbose=FALSE)
options(Cardinal.progress=FALSE)
options(width=100)


###################################################
### code chunk number 3: Cardinal-walkthrough.Rnw:72-75 (eval = FALSE)
###################################################
## name <- "This is the common name of your .hdr, .img, and .t2m files"
## folder <- "/This/is/the/path/to/the/folder/containing/the/files"
## data <- readAnalyze(name, folder)


###################################################
### code chunk number 4: Cardinal-walkthrough.Rnw:87-90 (eval = FALSE)
###################################################
## name <- "This is the common name of your .imzML and .ibd files"
## folder <- "/This/is/the/path/to/the/folder/containing/the/files"
## data <- readImzML(name, folder)


###################################################
### code chunk number 5: Cardinal-walkthrough.Rnw:99-101 (eval = FALSE)
###################################################
## file <- "/This/is/the/path/to/an/imaging/data/file.extension"
## data <- readMSIData(file)


###################################################
### code chunk number 6: Cardinal-walkthrough.Rnw:109-111 (eval = FALSE)
###################################################
## save(data, file="/Where/to/save/the/data.RData")
## load("/Where/to/save/the/data.RData")


###################################################
### code chunk number 7: Cardinal-walkthrough.Rnw:136-149
###################################################
pattern <- factor(c(0, 0, 2, 2, 0, 0, 0, 0, 0, 0, 2, 2, 0,
	0, 0, 0, 0, 0, 0, 1, 2, 2, 0, 0, 0, 0, 0, 2, 1, 1, 2,
	2, 0, 0, 0, 0, 0, 1, 2, 2, 2, 2, 0, 0, 0, 0, 1, 2, 2,
	2, 2, 2, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 2,
	2, 0, 0, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, 0),
	levels=c(0,1,2), labels=c("blue", "black", "red"))

set.seed(1)
msset <- generateImage(pattern, coord=expand.grid(x=1:9, y=1:9),
	range=c(1000, 5000), centers=c(2000, 3000, 4000),
	resolution=100, step=3.3, as="MSImageSet")

summary(msset)


###################################################
### code chunk number 8: Cardinal-walkthrough.Rnw:164-167
###################################################
head(mz(msset), n=10) # first 10 m/z values
head(coord(msset), n=10) # first 10 pixel coordinates
head(spectra(msset)[,1], n=10) # first 10 intensities in the first mass spectrum


###################################################
### code chunk number 9: Cardinal-walkthrough.Rnw:172-176
###################################################
nrow(msset)
ncol(msset)
dim(msset)
dims(msset)


###################################################
### code chunk number 10: Cardinal-walkthrough.Rnw:181-186
###################################################
features(msset, mz=3000) # returns the feature number most closely matching m/z 3000
mz(msset)[607]
pixels(msset, coord=list(x=5, y=5)) # returns the pixel number for x = 5, y = 5
pixels(msset, x=5, y=5) # also returns the pixel number for x = 5, y = 5
coord(msset)[41,]


###################################################
### code chunk number 11: Cardinal-walkthrough.Rnw:200-203
###################################################
tmp <- msset[2500 < mz(msset) & mz(msset) < 4500,]
range(mz(msset))
range(mz(tmp))


###################################################
### code chunk number 12: Cardinal-walkthrough.Rnw:208-211
###################################################
tmp <- msset[,coord(msset)$x > 5]
range(coord(msset)$x)
range(coord(tmp)$x)


###################################################
### code chunk number 13: Cardinal-walkthrough.Rnw:216-219
###################################################
tmp <- msset[2500 < mz(msset) & mz(msset) < 4500, coord(msset)$x > 5]
range(mz(tmp))
range(coord(tmp)$x)


###################################################
### code chunk number 14: plot1
###################################################
plot(msset, pixel=1)


###################################################
### code chunk number 15: plot2
###################################################
plot(msset, coord=list(x=5, y=5), plusminus=2)


###################################################
### code chunk number 16: plot3
###################################################
mycol <- c("blue", "black", "red")
plot(msset, pixel=1:ncol(msset), pixel.groups=pattern, superpose=TRUE, key=TRUE, col=mycol)


###################################################
### code chunk number 17: Cardinal-walkthrough.Rnw:254-255
###################################################
plot(msset, pixel=1)


###################################################
### code chunk number 18: Cardinal-walkthrough.Rnw:262-263
###################################################
plot(msset, coord=list(x=5, y=5), plusminus=2)


###################################################
### code chunk number 19: Cardinal-walkthrough.Rnw:270-271
###################################################
mycol <- c("blue", "black", "red")
plot(msset, pixel=1:ncol(msset), pixel.groups=pattern, superpose=TRUE, key=TRUE, col=mycol)


###################################################
### code chunk number 20: image1
###################################################
image(msset, feature=1)


###################################################
### code chunk number 21: image2
###################################################
image(msset, mz=4000, plusminus=10)


###################################################
### code chunk number 22: image3
###################################################
mycol <- c("blue", "black", "red")
image(msset, mz=c(2000, 3000, 4000), col=mycol, superpose=TRUE)


###################################################
### code chunk number 23: image4
###################################################
mycol <- gradient.colors(100, start="white", end="blue")
image(msset, mz=2000, col.regions=mycol, contrast.enhance="suppress")


###################################################
### code chunk number 24: image5
###################################################
mycol <- gradient.colors(100, start="white", end="black")
image(msset, mz=3000, col.regions=mycol, smooth.image="gaussian")


###################################################
### code chunk number 25: image6
###################################################
msset2 <- msset[,pattern == "black" | pattern == "red"]
mycol <- gradient.colors(100, start="black", end="red")
image(msset2, mz=4000, col.regions=mycol)


###################################################
### code chunk number 26: Cardinal-walkthrough.Rnw:327-328
###################################################
image(msset, feature=1)


###################################################
### code chunk number 27: Cardinal-walkthrough.Rnw:335-336
###################################################
image(msset, mz=4000, plusminus=10)


###################################################
### code chunk number 28: Cardinal-walkthrough.Rnw:343-344
###################################################
mycol <- c("blue", "black", "red")
image(msset, mz=c(2000, 3000, 4000), col=mycol, superpose=TRUE)


###################################################
### code chunk number 29: Cardinal-walkthrough.Rnw:351-352
###################################################
mycol <- gradient.colors(100, start="white", end="blue")
image(msset, mz=2000, col.regions=mycol, contrast.enhance="suppress")


###################################################
### code chunk number 30: Cardinal-walkthrough.Rnw:359-360
###################################################
mycol <- gradient.colors(100, start="white", end="black")
image(msset, mz=3000, col.regions=mycol, smooth.image="gaussian")


###################################################
### code chunk number 31: Cardinal-walkthrough.Rnw:367-368
###################################################
msset2 <- msset[,pattern == "black" | pattern == "red"]
mycol <- gradient.colors(100, start="black", end="red")
image(msset2, mz=4000, col.regions=mycol)


###################################################
### code chunk number 32: normalizetic
###################################################
normalize(msset, pixel=1, method="tic", plot=TRUE)


###################################################
### code chunk number 33: normalize
###################################################
msset2 <- normalize(msset, method="tic")


###################################################
### code chunk number 34: Cardinal-walkthrough.Rnw:398-399
###################################################
normalize(msset, pixel=1, method="tic", plot=TRUE)


###################################################
### code chunk number 35: smoothgaus
###################################################
smoothSignal(msset2, pixel=1, method="gaussian", window=9, plot=TRUE)


###################################################
### code chunk number 36: smoothsgolay
###################################################
smoothSignal(msset2, pixel=1, method="sgolay", window=15, plot=TRUE)


###################################################
### code chunk number 37: smooth
###################################################
msset3 <- smoothSignal(msset2, method="gaussian", window=9)


###################################################
### code chunk number 38: Cardinal-walkthrough.Rnw:425-426
###################################################
smoothSignal(msset2, pixel=1, method="gaussian", window=9, plot=TRUE)


###################################################
### code chunk number 39: Cardinal-walkthrough.Rnw:433-434
###################################################
smoothSignal(msset2, pixel=1, method="sgolay", window=15, plot=TRUE)


###################################################
### code chunk number 40: baselinemedian
###################################################
reduceBaseline(msset3, pixel=1, method="median", blocks=50, plot=TRUE)


###################################################
### code chunk number 41: baseline
###################################################
msset4 <- reduceBaseline(msset3, method="median", blocks=50)


###################################################
### code chunk number 42: Cardinal-walkthrough.Rnw:458-459
###################################################
reduceBaseline(msset3, pixel=1, method="median", blocks=50, plot=TRUE)


###################################################
### code chunk number 43: peakpickadaptive
###################################################
peakPick(msset4, pixel=1, method="adaptive", SNR=3, plot=TRUE)


###################################################
### code chunk number 44: peakpicklimpic
###################################################
peakPick(msset4, pixel=1, method="limpic", SNR=3, plot=TRUE)


###################################################
### code chunk number 45: peakpick
###################################################
msset5 <- peakPick(msset4, method="simple", SNR=3)


###################################################
### code chunk number 46: Cardinal-walkthrough.Rnw:485-486
###################################################
peakPick(msset4, pixel=1, method="adaptive", SNR=3, plot=TRUE)


###################################################
### code chunk number 47: Cardinal-walkthrough.Rnw:493-494
###################################################
peakPick(msset4, pixel=1, method="limpic", SNR=3, plot=TRUE)


###################################################
### code chunk number 48: peakaligndiff
###################################################
peakAlign(msset5, pixel=1, method="diff", plot=TRUE)


###################################################
### code chunk number 49: peakalign
###################################################
msset6 <- peakAlign(msset5, method="diff")


###################################################
### code chunk number 50: Cardinal-walkthrough.Rnw:515-516
###################################################
peakAlign(msset5, pixel=1, method="diff", plot=TRUE)


###################################################
### code chunk number 51: peakfilter
###################################################
msset7 <- peakFilter(msset6, method="freq")

dim(msset6) # 89 peaks retained

dim(msset7) # 10 peaks retained


###################################################
### code chunk number 52: reducedimbin
###################################################
reduceDimension(msset4, pixel=1, method="bin", width=25, fun=mean, plot=TRUE)


###################################################
### code chunk number 53: reducedimresample
###################################################
reduceDimension(msset4, pixel=1, method="resample", step=25, plot=TRUE)


###################################################
### code chunk number 54: reducedim
###################################################
msset8 <- reduceDimension(msset4, method="resample", step=25)


###################################################
### code chunk number 55: Cardinal-walkthrough.Rnw:562-563
###################################################
reduceDimension(msset4, pixel=1, method="bin", width=25, fun=mean, plot=TRUE)


###################################################
### code chunk number 56: Cardinal-walkthrough.Rnw:570-571
###################################################
reduceDimension(msset4, pixel=1, method="resample", step=25, plot=TRUE)


###################################################
### code chunk number 57: pca
###################################################
pca <- PCA(msset4, ncomp=2)


###################################################
### code chunk number 58: pcaplot
###################################################
plot(pca)


###################################################
### code chunk number 59: pcaimage
###################################################
image(pca)


###################################################
### code chunk number 60: Cardinal-walkthrough.Rnw:620-621
###################################################
plot(pca)


###################################################
### code chunk number 61: Cardinal-walkthrough.Rnw:628-629
###################################################
image(pca)


###################################################
### code chunk number 62: pls
###################################################
pls <- PLS(msset4, y=pattern, ncomp=2)


###################################################
### code chunk number 63: plsplot
###################################################
plot(pls, col=c("blue", "black", "red"))


###################################################
### code chunk number 64: plsimage
###################################################
image(pls, col=c("blue", "black", "red"))


###################################################
### code chunk number 65: Cardinal-walkthrough.Rnw:666-667
###################################################
plot(pls, col=c("blue", "black", "red"))


###################################################
### code chunk number 66: Cardinal-walkthrough.Rnw:674-675
###################################################
image(pls, col=c("blue", "black", "red"))


###################################################
### code chunk number 67: opls
###################################################
opls <- OPLS(msset4, y=pattern, ncomp=2)


###################################################
### code chunk number 68: oplsplot
###################################################
plot(opls, col=c("blue", "black", "red"))


###################################################
### code chunk number 69: oplsimage
###################################################
image(opls, col=c("blue", "black", "red"))


###################################################
### code chunk number 70: Cardinal-walkthrough.Rnw:708-709
###################################################
plot(opls, col=c("blue", "black", "red"))


###################################################
### code chunk number 71: Cardinal-walkthrough.Rnw:716-717
###################################################
image(opls, col=c("blue", "black", "red"))


###################################################
### code chunk number 72: skm
###################################################
set.seed(1)
skm <- spatialKMeans(msset7, r=2, k=3, method="adaptive")


###################################################
### code chunk number 73: skmplot
###################################################
plot(skm, col=c("black", "blue", "red"), type=c('p','h'), key=FALSE)


###################################################
### code chunk number 74: skmimage
###################################################
image(skm, col=c("black", "blue", "red"), key=FALSE)


###################################################
### code chunk number 75: Cardinal-walkthrough.Rnw:755-756
###################################################
plot(skm, col=c("black", "blue", "red"), type=c('p','h'), key=FALSE)


###################################################
### code chunk number 76: Cardinal-walkthrough.Rnw:763-764
###################################################
image(skm, col=c("black", "blue", "red"), key=FALSE)


###################################################
### code chunk number 77: ssc
###################################################
set.seed(1)
ssc <- spatialShrunkenCentroids(msset7, r=1, k=5, s=3, method="adaptive")


###################################################
### code chunk number 78: sscplot
###################################################
plot(ssc, col=c("blue", "red", "black"), type=c('p','h'), key=FALSE)


###################################################
### code chunk number 79: sscimage
###################################################
image(ssc, col=c("blue", "red", "black"), key=FALSE)


###################################################
### code chunk number 80: Cardinal-walkthrough.Rnw:803-804
###################################################
plot(ssc, col=c("blue", "red", "black"), type=c('p','h'), key=FALSE)


###################################################
### code chunk number 81: Cardinal-walkthrough.Rnw:811-812
###################################################
image(ssc, col=c("blue", "red", "black"), key=FALSE)


###################################################
### code chunk number 82: Cardinal-walkthrough.Rnw:837-839 (eval = FALSE)
###################################################
## source("http://bioconductor.org/biocLite.R")
## biocLite("CardinalWorkflows")


###################################################
### code chunk number 83: Cardinal-walkthrough.Rnw:871-872 (eval = FALSE)
###################################################
## vignette("Workflows-clustering")


###################################################
### code chunk number 84: Cardinal-walkthrough.Rnw:877-878 (eval = FALSE)
###################################################
## data(pig206, pig206_analyses)


###################################################
### code chunk number 85: Cardinal-walkthrough.Rnw:908-909 (eval = FALSE)
###################################################
## vignette("Workflows-classification")


###################################################
### code chunk number 86: Cardinal-walkthrough.Rnw:914-915 (eval = FALSE)
###################################################
## data(rcc, rcc_analyses)


###################################################
### code chunk number 87: pData
###################################################
pData(msset)$pg <- pattern


###################################################
### code chunk number 88: fData
###################################################
fData(msset)$fg <- factor(rep("bg", nrow(fData(msset))), levels=c("bg","blue", "black", "red"))
fData(msset)$fg[1950 < fData(msset)$mz & fData(msset)$mz < 2050] <- "blue"
fData(msset)$fg[2950 < fData(msset)$mz & fData(msset)$mz < 3050] <- "black"
fData(msset)$fg[3950 < fData(msset)$mz & fData(msset)$mz < 4050] <- "red"


###################################################
### code chunk number 89: pixelApply1
###################################################
p1 <- pixelApply(msset, mean, .feature.groups=fg)
p1[,1:30]


###################################################
### code chunk number 90: pixelApply2
###################################################
cbind(pData(msset), t(p1))[1:30,c("pg","blue", "black", "red")]


###################################################
### code chunk number 91: pixelApply3
###################################################
tmp1 <- MSImageSet(spectra=t(as.vector(p1["blue",])), coord=coord(msset), mz=2000)
image(tmp1, feature=1, col.regions=alpha.colors(100, "blue"), sub="m/z = 2000")


###################################################
### code chunk number 92: pixelApply4
###################################################
tmp1 <- MSImageSet(spectra=t(as.vector(p1["black",])), coord=coord(msset), mz=3000)
image(tmp1, feature=1, col.regions=alpha.colors(100, "black"), sub="m/z = 3000")


###################################################
### code chunk number 93: pixelApply5
###################################################
tmp2 <- MSImageSet(spectra=t(as.vector(p1["red",])), coord=coord(msset), mz=4000)
image(tmp2, feature=1, col.regions=alpha.colors(100, "red"),  sub="m/z = 4000")


###################################################
### code chunk number 94: Cardinal-walkthrough.Rnw:1015-1016
###################################################
tmp1 <- MSImageSet(spectra=t(as.vector(p1["blue",])), coord=coord(msset), mz=2000)
image(tmp1, feature=1, col.regions=alpha.colors(100, "blue"), sub="m/z = 2000")


###################################################
### code chunk number 95: Cardinal-walkthrough.Rnw:1023-1024
###################################################
tmp1 <- MSImageSet(spectra=t(as.vector(p1["black",])), coord=coord(msset), mz=3000)
image(tmp1, feature=1, col.regions=alpha.colors(100, "black"), sub="m/z = 3000")


###################################################
### code chunk number 96: Cardinal-walkthrough.Rnw:1031-1032
###################################################
tmp2 <- MSImageSet(spectra=t(as.vector(p1["red",])), coord=coord(msset), mz=4000)
image(tmp2, feature=1, col.regions=alpha.colors(100, "red"),  sub="m/z = 4000")


###################################################
### code chunk number 97: featureApply1
###################################################
f1 <- featureApply(msset, mean, .pixel.groups=pg)
f1[,1:30]


###################################################
### code chunk number 98: featureApply2
###################################################
plot(mz(msset), f1["blue",], type="l", xlab="m/z", ylab="Intensity", col="blue")


###################################################
### code chunk number 99: featureApply3
###################################################
plot(mz(msset), f1["black",], type="l", xlab="m/z", ylab="Intensity", col="black")


###################################################
### code chunk number 100: featureApply4
###################################################
plot(mz(msset), f1["red",], type="l", xlab="m/z", ylab="Intensity", col="red")


###################################################
### code chunk number 101: Cardinal-walkthrough.Rnw:1071-1072
###################################################
plot(mz(msset), f1["blue",], type="l", xlab="m/z", ylab="Intensity", col="blue")


###################################################
### code chunk number 102: Cardinal-walkthrough.Rnw:1079-1080
###################################################
plot(mz(msset), f1["black",], type="l", xlab="m/z", ylab="Intensity", col="black")


###################################################
### code chunk number 103: Cardinal-walkthrough.Rnw:1087-1088
###################################################
plot(mz(msset), f1["red",], type="l", xlab="m/z", ylab="Intensity", col="red")


###################################################
### code chunk number 104: Cardinal
###################################################
options(width=69)
library(Cardinal)
options(Cardinal.verbose=FALSE)
options(Cardinal.progress=FALSE)


###################################################
### code chunk number 105: gs1
###################################################
set.seed(1)
s1 <- generateSpectrum(1, range=c(1001, 20000), centers=runif(50, 1001, 20000), baseline=2000, resolution=100, step=3.3)
plot(x ~ t, data=s1, type="l", xlab="m/z", ylab="Intensity")


###################################################
### code chunk number 106: gs2
###################################################
set.seed(2)
s2 <- generateSpectrum(1, range=c(1001, 20000), centers=runif(20, 1001, 20000), baseline=3000, resolution=50, step=3.3)
plot(x ~ t, data=s2, type="l", xlab="m/z", ylab="Intensity")


###################################################
### code chunk number 107: Cardinal-walkthrough.Rnw:1144-1145
###################################################
set.seed(1)
s1 <- generateSpectrum(1, range=c(1001, 20000), centers=runif(50, 1001, 20000), baseline=2000, resolution=100, step=3.3)
plot(x ~ t, data=s1, type="l", xlab="m/z", ylab="Intensity")


###################################################
### code chunk number 108: Cardinal-walkthrough.Rnw:1152-1153
###################################################
set.seed(2)
s2 <- generateSpectrum(1, range=c(1001, 20000), centers=runif(20, 1001, 20000), baseline=3000, resolution=50, step=3.3)
plot(x ~ t, data=s2, type="l", xlab="m/z", ylab="Intensity")


###################################################
### code chunk number 109: gs3
###################################################
set.seed(3)
s3 <- generateSpectrum(1, range=c(101, 1000), centers=runif(25, 101, 1000), baseline=0, resolution=250, noise=0.1, step=1.2)
plot(x ~ t, data=s3, type="l", xlab="m/z", ylab="Intensity")


###################################################
### code chunk number 110: gs4
###################################################
set.seed(4)
s4 <- generateSpectrum(1, range=c(101, 1000), centers=runif(100, 101, 1000), baseline=0, resolution=500, noise=0.2, step=1.2)
plot(x ~ t, data=s4, type="l", xlab="m/z", ylab="Intensity")


###################################################
### code chunk number 111: Cardinal-walkthrough.Rnw:1181-1182
###################################################
set.seed(3)
s3 <- generateSpectrum(1, range=c(101, 1000), centers=runif(25, 101, 1000), baseline=0, resolution=250, noise=0.1, step=1.2)
plot(x ~ t, data=s3, type="l", xlab="m/z", ylab="Intensity")


###################################################
### code chunk number 112: Cardinal-walkthrough.Rnw:1189-1190
###################################################
set.seed(4)
s4 <- generateSpectrum(1, range=c(101, 1000), centers=runif(100, 101, 1000), baseline=0, resolution=500, noise=0.2, step=1.2)
plot(x ~ t, data=s4, type="l", xlab="m/z", ylab="Intensity")


###################################################
### code chunk number 113: data
###################################################
data <- matrix(c(NA, NA, 1, 1, NA, NA, NA, NA, NA, NA, 1, 1, NA, NA, 
 NA, NA, NA, NA, NA, 0, 1, 1, NA, NA, NA, NA, NA, 1, 0, 0, 1, 
 1, NA, NA, NA, NA, NA, 0, 1, 1, 1, 1, NA, NA, NA, NA, 0, 1, 1, 
 1, 1, 1, NA, NA, NA, NA, 1, 1, 1, 1, 1, 1, 1, NA, NA, NA, 1, 
 1, NA, NA, NA, NA, NA, NA, 1, 1, NA, NA, NA, NA, NA), nrow=9, ncol=9)


###################################################
### code chunk number 114: truth
###################################################
image(data[,ncol(data):1], col=c("black", "red"))


###################################################
### code chunk number 115: Cardinal-walkthrough.Rnw:1221-1222
###################################################
image(data[,ncol(data):1], col=c("black", "red"))


###################################################
### code chunk number 116: img1
###################################################
set.seed(1)
img1 <- generateImage(data, range=c(1,1000), centers=c(100,200), step=1, as="MSImageSet")


###################################################
### code chunk number 117: gi1
###################################################
image(img1, mz=100, col.regions=alpha.colors(100, "black"))


###################################################
### code chunk number 118: gi2
###################################################
image(img1, mz=200, col.regions=alpha.colors(100, "red"))


###################################################
### code chunk number 119: Cardinal-walkthrough.Rnw:1248-1249
###################################################
image(img1, mz=100, col.regions=alpha.colors(100, "black"))


###################################################
### code chunk number 120: Cardinal-walkthrough.Rnw:1256-1257
###################################################
image(img1, mz=200, col.regions=alpha.colors(100, "red"))


###################################################
### code chunk number 121: img2
###################################################
pattern <- factor(c(0, 0, 2, 2, 0, 0, 0, 0, 0, 0, 2, 2, 0,
  0, 0, 0, 0, 0, 0, 1, 2, 2, 0, 0, 0, 0, 0, 2, 1, 1, 2,
  2, 0, 0, 0, 0, 0, 1, 2, 2, 2, 2, 0, 0, 0, 0, 1, 2, 2,
	2, 2, 2, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 2,
	2, 0, 0, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, 0),
	levels=c(0,1,2), labels=c("blue", "black", "red"))
coord <- expand.grid(x=1:9, y=1:9)
set.seed(2)
msset <- generateImage(pattern, coord=coord, range=c(1000, 5000), centers=c(2000, 3000, 4000), resolution=100, step=3.3, as="MSImageSet")


###################################################
### code chunk number 122: gi3
###################################################
image(msset, mz=2000, col.regions=alpha.colors(100, "blue"))


###################################################
### code chunk number 123: gi4
###################################################
image(msset, mz=3000, col.regions=alpha.colors(100, "black"))


###################################################
### code chunk number 124: gi5
###################################################
image(msset, mz=4000, col.regions=alpha.colors(100, "red"))


###################################################
### code chunk number 125: Cardinal-walkthrough.Rnw:1300-1301
###################################################
image(msset, mz=2000, col.regions=alpha.colors(100, "blue"))


###################################################
### code chunk number 126: Cardinal-walkthrough.Rnw:1308-1309
###################################################
image(msset, mz=3000, col.regions=alpha.colors(100, "black"))


###################################################
### code chunk number 127: Cardinal-walkthrough.Rnw:1316-1317
###################################################
image(msset, mz=4000, col.regions=alpha.colors(100, "red"))


###################################################
### code chunk number 128: adv1
###################################################
x1 <- apply(expand.grid(x=1:10, y=1:10), 1, 
            function(z) 1/(1 + ((4-z[[1]])/2)^2 + ((4-z[[2]])/2)^2))
dim(x1) <- c(10,10)
image(x1[,ncol(x1):1])


###################################################
### code chunk number 129: adv2
###################################################
x2 <- apply(expand.grid(x=1:10, y=1:10), 1, 
            function(z) 1/(1 + ((6-z[[1]])/2)^2 + ((6-z[[2]])/2)^2))
dim(x2) <- c(10,10)
image(x2[,ncol(x2):1])


###################################################
### code chunk number 130: Cardinal-walkthrough.Rnw:1349-1350
###################################################
x1 <- apply(expand.grid(x=1:10, y=1:10), 1, 
            function(z) 1/(1 + ((4-z[[1]])/2)^2 + ((4-z[[2]])/2)^2))
dim(x1) <- c(10,10)
image(x1[,ncol(x1):1])


###################################################
### code chunk number 131: Cardinal-walkthrough.Rnw:1357-1358
###################################################
x2 <- apply(expand.grid(x=1:10, y=1:10), 1, 
            function(z) 1/(1 + ((6-z[[1]])/2)^2 + ((6-z[[2]])/2)^2))
dim(x2) <- c(10,10)
image(x2[,ncol(x2):1])


###################################################
### code chunk number 132: advsim
###################################################
set.seed(1)
x3 <- mapply(function(z1, z2) generateSpectrum(1, centers=c(500,510), intensities=c(z1, z2), range=c(1,1000), resolution=100, baseline=0, step=1)$x, as.vector(x1), as.vector(x2))
img3 <- MSImageSet(x3, coord=expand.grid(x=1:10, y=1:10), mz=1:1000)


###################################################
### code chunk number 133: advimg1
###################################################
image(img3, mz=500, col=intensity.colors(100))


###################################################
### code chunk number 134: advimg2
###################################################
image(img3, mz=510, col=intensity.colors(100))


###################################################
### code chunk number 135: Cardinal-walkthrough.Rnw:1394-1395
###################################################
image(img3, mz=500, col=intensity.colors(100))


###################################################
### code chunk number 136: Cardinal-walkthrough.Rnw:1402-1403
###################################################
image(img3, mz=510, col=intensity.colors(100))


###################################################
### code chunk number 137: advplot1
###################################################
plot(img3, coord=list(x=4, y=4), type="l", xlim=c(200, 800))


###################################################
### code chunk number 138: advplot2
###################################################
plot(img3, coord=list(x=6, y=6), type="l", xlim=c(200, 800))


###################################################
### code chunk number 139: Cardinal-walkthrough.Rnw:1428-1429
###################################################
plot(img3, coord=list(x=4, y=4), type="l", xlim=c(200, 800))


###################################################
### code chunk number 140: Cardinal-walkthrough.Rnw:1436-1437
###################################################
plot(img3, coord=list(x=6, y=6), type="l", xlim=c(200, 800))


###################################################
### code chunk number 141: Cardinal-walkthrough.Rnw:1452-1453
###################################################
toLatex(sessionInfo())


