/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bridgedb.DataSource;
import org.bridgedb.IDMapper;
import org.bridgedb.IDMapperException;
import org.bridgedb.IDMapperTestBase;
import org.bridgedb.Xref;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public abstract class IDMapperTest
extends IDMapperTestBase {
    protected static IDMapper idMapper;
    protected static boolean connectionOk;

    @AfterClass
    public static void testClose() throws IDMapperException {
        if (connectionOk) {
            Assert.assertTrue((boolean)idMapper.isConnected());
            idMapper.close();
            Assert.assertFalse((boolean)idMapper.isConnected());
        }
    }

    @Test
    public void testMapIDManyToManyNoDataSources() throws IDMapperException {
        IDMapperTest.report("MapIDManyToManyNoDataSources");
        HashSet<Xref> srcXrefs = new HashSet<Xref>();
        srcXrefs.add(map1xref1);
        srcXrefs.add(map2xref2);
        srcXrefs.add(mapBadxref1);
        Map<Xref, Set<Xref>> results = idMapper.mapID(srcXrefs, new DataSource[0]);
        Set<Xref> resultSet = results.get(map1xref1);
        Assert.assertNotNull(resultSet);
        Assert.assertTrue((boolean)resultSet.contains(map1xref2));
        Assert.assertTrue((boolean)resultSet.contains(map1xref3));
        Assert.assertFalse((boolean)resultSet.contains(map2xref1));
        Assert.assertFalse((boolean)resultSet.contains(map2xref3));
        resultSet = results.get(map2xref2);
        Assert.assertNotNull(resultSet);
        Assert.assertFalse((boolean)resultSet.contains(map1xref2));
        Assert.assertFalse((boolean)resultSet.contains(map1xref3));
        Assert.assertTrue((boolean)resultSet.contains(map2xref1));
        Assert.assertTrue((boolean)resultSet.contains(map2xref3));
        resultSet = results.get(map2xref1);
        Assert.assertNull(resultSet);
        resultSet = results.get(map3xref1);
        Assert.assertNull(resultSet);
        resultSet = results.get(mapBadxref1);
        Assert.assertTrue((resultSet == null || resultSet.isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void testMapIDOneToManyNoDataSources() throws IDMapperException {
        IDMapperTest.report("MapIDOneToManyNoDataSources");
        Set<Xref> results = idMapper.mapID(map1xref1, new DataSource[0]);
        Assert.assertTrue((boolean)results.contains(map1xref2));
        Assert.assertTrue((boolean)results.contains(map1xref3));
        Assert.assertFalse((boolean)results.contains(map2xref1));
        Assert.assertFalse((boolean)results.contains(map2xref2));
        Assert.assertFalse((boolean)results.contains(map2xref2));
    }

    @Test
    public void testMapIDOneBad() throws IDMapperException {
        IDMapperTest.report("MapIDOneToManyNoDataSources");
        Set<Xref> results = idMapper.mapID(mapBadxref1, new DataSource[0]);
        Assert.assertEquals((long)0L, (long)results.size());
    }

    @Test
    public void testMapIDOneToManyWithOneDataSource() throws IDMapperException {
        IDMapperTest.report("MapIDOneToManyWithOneDataSource");
        Set<Xref> results = idMapper.mapID(map1xref1, DataSource2);
        Assert.assertTrue((boolean)results.contains(map1xref2));
        Assert.assertFalse((boolean)results.contains(map1xref3));
        Assert.assertFalse((boolean)results.contains(map2xref1));
        Assert.assertFalse((boolean)results.contains(map2xref2));
        Assert.assertFalse((boolean)results.contains(map2xref2));
    }

    @Test
    public void testMapIDOneToManyWithTwoDataSources() throws IDMapperException {
        IDMapperTest.report("MapIDOneToManyWithTwoDataSources");
        Set<Xref> results = idMapper.mapID(map1xref1, DataSource2, DataSource3);
        Assert.assertTrue((boolean)results.contains(map1xref2));
        Assert.assertTrue((boolean)results.contains(map1xref3));
        Assert.assertFalse((boolean)results.contains(map2xref1));
        Assert.assertFalse((boolean)results.contains(map2xref2));
        Assert.assertFalse((boolean)results.contains(map2xref2));
    }

    @Test
    public void testMapIDOneToManyNoDataSources2() throws IDMapperException {
        IDMapperTest.report("MapIDOneToManyNoDataSources");
        Set<Xref> results = idMapper.mapID(map2xref1, new DataSource[0]);
        Assert.assertTrue((boolean)results.contains(map2xref2));
        Assert.assertTrue((boolean)results.contains(map2xref3));
        Assert.assertFalse((boolean)results.contains(map1xref2));
        Assert.assertFalse((boolean)results.contains(map3xref2));
    }

    @Test
    public void testXrefSupported() throws Exception {
        IDMapperTest.report("XrefSupported");
        Assert.assertTrue((boolean)idMapper.xrefExists(map1xref1));
        Assert.assertTrue((boolean)idMapper.xrefExists(map1xref2));
        Assert.assertTrue((boolean)idMapper.xrefExists(map1xref3));
        Assert.assertTrue((boolean)idMapper.xrefExists(map2xref1));
        Assert.assertTrue((boolean)idMapper.xrefExists(map2xref2));
        Assert.assertTrue((boolean)idMapper.xrefExists(map2xref3));
        Assert.assertTrue((boolean)idMapper.xrefExists(map3xref1));
        Assert.assertTrue((boolean)idMapper.xrefExists(map3xref2));
        Assert.assertTrue((boolean)idMapper.xrefExists(map3xref3));
        Assert.assertFalse((boolean)idMapper.xrefExists(mapBadxref1));
        Assert.assertFalse((boolean)idMapper.xrefExists(mapBadxref2));
        Assert.assertFalse((boolean)idMapper.xrefExists(mapBadxref3));
    }

    @Test
    public void testFreeSearchBad() throws IDMapperException {
        Assume.assumeTrue((boolean)idMapper.getCapabilities().isFreeSearchSupported());
        Assume.assumeTrue((badID != null ? 1 : 0) != 0);
        IDMapperTest.report("FreeSearchBad");
        Set<Xref> results = idMapper.freeSearch(badID, 10);
        Assert.assertTrue((results == null || results.isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void testFreeSearchGood() throws IDMapperException {
        Assume.assumeTrue((boolean)idMapper.getCapabilities().isFreeSearchSupported());
        IDMapperTest.report("FreeSearchGood");
        Set<Xref> results = idMapper.freeSearch(goodId1, 1000);
        Assert.assertTrue((boolean)results.contains(map1xref1));
        Assert.assertTrue((boolean)results.contains(map1xref2));
        Assert.assertTrue((boolean)results.contains(map1xref3));
        Assert.assertFalse((boolean)results.contains(map2xref1));
    }

    @Test
    public void testFreeSearchGoodJust2() throws IDMapperException {
        Assume.assumeTrue((boolean)idMapper.getCapabilities().isFreeSearchSupported());
        IDMapperTest.report("FreeSearchGoodJust2");
        Set<Xref> results = idMapper.freeSearch(goodId1, 2);
        Assert.assertEquals((long)2L, (long)results.size());
    }

    @Test
    public void testXrefWithHalfNullXrefs() throws IDMapperException {
        IDMapperTest.report("XrefWithHalfNullXrefs");
        Assert.assertFalse((boolean)idMapper.xrefExists(HALFNULL1));
        Assert.assertFalse((boolean)idMapper.xrefExists(HALFNULL2));
    }

    @Test
    public void testIDMapperHalfNullXrefs() throws IDMapperException {
        IDMapperTest.report("IDMapperHalfNullXrefs");
        Set<Xref> result = idMapper.mapID(HALFNULL1, new DataSource[0]);
        Assert.assertTrue((result == null || result.isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void testIDMapperHalfNullXrefs2() throws IDMapperException {
        IDMapperTest.report("IDMapperHalfNullXrefs2");
        Set<Xref> result = idMapper.mapID(HALFNULL2, new DataSource[0]);
        Assert.assertTrue((result == null || result.isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void testIDMapperHalfNullXrefs3() throws IDMapperException {
        IDMapperTest.report("IDMapperHalfNullXrefs3");
        Set<Xref> result = idMapper.mapID(HALFNULL1, DataSource2, DataSource3);
        Assert.assertTrue((result == null || result.isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void testIDMapperHalfNullXrefs4() throws IDMapperException {
        IDMapperTest.report("IDMapperHalfNullXrefs4");
        Set<Xref> result = idMapper.mapID(HALFNULL2, DataSource2, DataSource3);
        Assert.assertTrue((result == null || result.isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void testIDMapperSeveralHalfNullXrefs() throws IDMapperException {
        IDMapperTest.report("IDMapperSeveralHalfNullXrefs");
        HashSet<Xref> src = new HashSet<Xref>();
        src.add(HALFNULL1);
        src.add(HALFNULL2);
        Map<Xref, Set<Xref>> result = idMapper.mapID(src, DataSource2, DataSource3);
        Assert.assertTrue((result == null || result.isEmpty() ? 1 : 0) != 0);
    }

    static {
        connectionOk = true;
    }
}

