/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb;

import java.util.Set;
import org.bridgedb.DataSource;
import org.bridgedb.IDMapperCapabilities;
import org.bridgedb.IDMapperException;
import org.bridgedb.IDMapperTestBase;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public abstract class IDMapperCapabilitiesTest
extends IDMapperTestBase {
    protected static IDMapperCapabilities capabilities;

    @Test
    public void testDataSourceSupported() throws Exception {
        IDMapperCapabilitiesTest.report("DataSourceSupported");
        Set<DataSource> dataSources = capabilities.getSupportedSrcDataSources();
        DataSource expected = dataSources.iterator().next();
        Assert.assertTrue((boolean)dataSources.contains(DataSource1));
        Assert.assertTrue((boolean)dataSources.contains(DataSource2));
        Assert.assertTrue((boolean)dataSources.contains(DataSource3));
        Assert.assertFalse((boolean)dataSources.contains(DataSourceBad));
    }

    @Test
    public void testDataTargetSupported() throws Exception {
        IDMapperCapabilitiesTest.report("DataTagerSupported");
        Set<DataSource> dataSources = capabilities.getSupportedTgtDataSources();
        DataSource expected = dataSources.iterator().next();
        Assert.assertTrue((boolean)dataSources.contains(DataSource1));
        Assert.assertTrue((boolean)dataSources.contains(DataSource2));
        Assert.assertTrue((boolean)dataSources.contains(DataSource3));
        Assert.assertFalse((boolean)dataSources.contains(DataSourceBad));
    }

    @Test
    public void testIsMappingSupported() throws IDMapperException {
        IDMapperCapabilitiesTest.report("isMappingSupported");
        Assert.assertTrue((boolean)capabilities.isMappingSupported(DataSource1, DataSource2));
        Assert.assertFalse((boolean)capabilities.isMappingSupported(DataSource1, DataSourceBad));
    }

    @Test
    public void testGetKeys() throws IDMapperException {
        IDMapperCapabilitiesTest.report("GetKeys");
        Assert.assertNotNull(capabilities.getKeys());
    }

    @Test
    public void testKeysHaveProperties() {
        IDMapperCapabilitiesTest.report("KeysHaveProperties");
        for (String key : capabilities.getKeys()) {
            System.out.println("key: " + key);
            System.out.println("property: " + capabilities.getProperty(key));
            Assert.assertNotNull((Object)capabilities.getProperty(key));
        }
    }

    @Test
    @Ignore
    public void testBadKeyNoProperties() {
        IDMapperCapabilitiesTest.report("BadKeyNoProperties");
        Assert.assertNull((Object)capabilities.getProperty(badKey));
    }
}

