/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb;

import org.bridgedb.DataSource;
import org.bridgedb.IDMapperException;
import org.bridgedb.Xref;
import org.junit.Assert;
import org.junit.Test;

public class DataSourceTest {
    @Test
    public void testAsDataSource() {
        DataSource source = DataSource.register("X", "Affymetrix").asDataSource();
        Assert.assertNotNull((Object)source);
    }

    @Test
    public void testBuilding() {
        DataSource source = DataSource.register("X", "Affymetrix").asDataSource();
        Assert.assertEquals((Object)"X", (Object)source.getSystemCode());
        Assert.assertEquals((Object)"Affymetrix", (Object)source.getFullName());
    }

    @Test
    public void testBuildingMainUrl() {
        DataSource source = DataSource.register("X", "Affymetrix").mainUrl("http://www.affymetrix.com").asDataSource();
        Assert.assertEquals((Object)"http://www.affymetrix.com", (Object)source.getMainUrl());
    }

    @Test
    public void testBuildingType() {
        DataSource source = DataSource.register("X", "Affymetrix").type("probe").asDataSource();
        Assert.assertEquals((Object)"probe", (Object)source.getType());
        Assert.assertFalse((boolean)source.isMetabolite());
    }

    @Test
    public void testBuildingPrimary() {
        DataSource source = DataSource.register("X", "Affymetrix").primary(false).asDataSource();
        Assert.assertFalse((boolean)source.isPrimary());
        source = DataSource.register("X", "Affymetrix").primary(true).asDataSource();
        Assert.assertTrue((boolean)source.isPrimary());
    }

    @Test
    public void testBuildingMetabolite() {
        DataSource source = DataSource.register("F", "MetaboLoci").type("metabolite").asDataSource();
        Assert.assertEquals((Object)"metabolite", (Object)source.getType());
        Assert.assertTrue((boolean)source.isMetabolite());
    }

    @Test
    public void testGetByURLPattern() throws Exception {
        String urlProfile = "http://www.example1.com/$id";
        DataSource expResult = DataSource.register("test1", "test1").urlPattern(urlProfile).asDataSource();
        DataSource result = DataSource.getByURL((String)urlProfile);
        Assert.assertEquals((Object)expResult, (Object)result);
    }

    @Test
    public void testGetByURLDifferentURL() throws Exception {
        String urlProfile = "http://www.example2.com/$id";
        String url = "http://www.example2.com/12345";
        DataSource expResult = DataSource.register("test1", "test1").urlPattern(urlProfile).asDataSource();
        DataSource result = DataSource.getByURL((String)url);
        Assert.assertEquals((Object)expResult, (Object)result);
    }

    @Test
    public void testGetByNameSpace() throws Exception {
        String nameSpace = "http://www.example1.com/";
        String urlProfile = "http://www.example1.com/$id";
        DataSource expResult = DataSource.register("test1", "test1").nameSpace(nameSpace).asDataSource();
        DataSource result = DataSource.getByURL((String)urlProfile);
        Assert.assertEquals((Object)expResult, (Object)result);
        result = DataSource.getByNameSpace((String)nameSpace);
        Assert.assertEquals((Object)expResult, (Object)result);
    }

    @Test
    public void testXrefByURLDifferentURL() throws Exception {
        String urlProfile = "http://www.example2.com/$id";
        String url = "http://www.example2.com/12345";
        DataSource dataSource = DataSource.register("test1", "test1").urlPattern(urlProfile).asDataSource();
        Xref expResult = new Xref("12345", dataSource);
        Xref result = DataSource.uriToXref((String)url);
        Assert.assertEquals((Object)expResult, (Object)result);
        String newURL = result.getUrl();
        Assert.assertEquals((Object)url, (Object)newURL);
    }

    @Test
    public void testGetByURLChangedPattern() throws Exception {
        DataSource result;
        String urlProfile1 = "http://www.example3.com/Pizza/$id";
        String urlProfile2 = "http://www.example3.com/Bread/$id";
        String url1 = "http://www.example3.com/Pizza/12345";
        String url2 = "http://www.example3.com/Bread/12345";
        DataSource expResult = DataSource.register("test1", "test1").urlPattern(urlProfile1).asDataSource();
        Assert.assertTrue((expResult == (result = DataSource.getByURL((String)url1)) ? 1 : 0) != 0);
        expResult = DataSource.register("test1", "test1").urlPattern(urlProfile2).asDataSource();
        result = DataSource.getByURL((String)url1);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((expResult != result ? 1 : 0) != 0);
        result = DataSource.getByURL((String)url2);
        Assert.assertTrue((expResult == result ? 1 : 0) != 0);
    }

    @Test
    public void testXrefByURLChangedPattern() throws Exception {
        String urlProfile1 = "http://www.example3a.com/Pizza/$id";
        String urlProfile2 = "http://www.example3a.com/Bread/$id";
        String url1 = "http://www.example3a.com/Pizza/12345";
        String url2 = "http://www.example3a.com/Bread/12345";
        DataSource dataSource = DataSource.register("test1", "test1").urlPattern(urlProfile1).asDataSource();
        Xref expResult = new Xref("12345", dataSource);
        Xref result = DataSource.uriToXref((String)url1);
        Assert.assertEquals((Object)expResult, (Object)result);
        Assert.assertEquals((Object)url1, (Object)result.getUrl());
        DataSource.register("test1", "test1").urlPattern(urlProfile2);
        result = DataSource.uriToXref((String)url1);
        Assert.assertEquals((Object)url1, (Object)result.getUrl());
        result = DataSource.uriToXref((String)url2);
        Assert.assertEquals((Object)expResult, (Object)result);
        Assert.assertEquals((Object)url2, (Object)result.getUrl());
    }

    @Test
    public void testGetByURLSeveralURL() throws Exception {
        String urlProfile = "http://www.example4.com/$id";
        String url = "http://www.example4.com/12345";
        DataSource expResult = DataSource.register("test1", "test1").urlPattern(urlProfile).asDataSource();
        DataSource.register("testx1", "testx1").urlPattern("http://www.example4.com/Pizza#$id").asDataSource();
        DataSource.register("testx2", "testx2").urlPattern("http://www.example4.com/Bread#$id").asDataSource();
        DataSource.register("testx3", "testx3").urlPattern("http://www.example4.com/Pizza/$id").asDataSource();
        DataSource.register("testx4", "testx4").urlPattern("http://www.example4.com/Pizza:$id").asDataSource();
        DataSource result = DataSource.getByURL((String)url);
        Assert.assertEquals((Object)expResult, (Object)result);
    }

    @Test
    public void testGetByURLWithPostFix() throws Exception {
        String urlProfile = "http://www.example5.com/$id/more";
        DataSource expResult = DataSource.register("test1", "test1").urlPattern(urlProfile).asDataSource();
        DataSource result = DataSource.getByURLPattern((String)urlProfile);
        Assert.assertEquals((Object)expResult, (Object)result);
    }

    @Test
    public void testGetByURLDifferentURWithPostFix() throws Exception {
        String urlProfile = "http://www.example6.com/$id/more";
        String url = "http://www.example6.com/12345/more";
        DataSource expResult = DataSource.register("test1", "test1").urlPattern(urlProfile).asDataSource();
        DataSource result = DataSource.getByURL((String)url);
        Assert.assertEquals((Object)expResult, (Object)result);
    }

    @Test
    public void testXrefByURLDifferentURWithPostFix() throws Exception {
        String urlProfile = "http://www.example6.com/$id/more";
        String url = "http://www.example6.com/12345/more";
        DataSource dataSource = DataSource.register("test1", "test1").urlPattern(urlProfile).asDataSource();
        Xref expResult = new Xref("12345", dataSource);
        Xref result = DataSource.uriToXref((String)url);
        Assert.assertEquals((Object)expResult, (Object)result);
    }

    @Test
    public void testGetByURLChangedPatternWithPostFix() throws Exception {
        String urlProfile1 = "http://www.example7.com/Pizza/$id/more";
        String urlProfile2 = "http://www.example7.com/Bread/$id/more";
        String url1 = "http://www.example7.com/Pizza/12345/more";
        String url2 = "http://www.example7.com/Bread/12345/more";
        DataSource expResult = DataSource.register("test1", "test1").urlPattern(urlProfile1).asDataSource();
        DataSource result = DataSource.getByURL((String)url1);
        Assert.assertEquals((Object)expResult, (Object)result);
        expResult = DataSource.register("test1", "test1").urlPattern(urlProfile2).asDataSource();
        result = DataSource.getByURL((String)url1);
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)expResult.equals(result));
        result = DataSource.getByURL((String)url2);
        Assert.assertEquals((Object)expResult, (Object)result);
    }

    @Test
    public void testXrefByURLChangedPatternWithPostFix() throws Exception {
        String urlProfile1 = "http://www.example7a.com/Pizza/$id/more";
        String urlProfile2 = "http://www.example7a.com/Bread/$id/more";
        String url1 = "http://www.example7a.com/Pizza/12345/more";
        String url2 = "http://www.example7a.com/Bread/12345/more";
        DataSource dataSource = DataSource.register("test1", "test1").urlPattern(urlProfile1).asDataSource();
        Xref expResult = new Xref("12345", dataSource);
        Xref result = DataSource.uriToXref((String)url1);
        Assert.assertEquals((Object)expResult, (Object)result);
        Assert.assertEquals((Object)url1, (Object)result.getUrl());
        DataSource.register("test1", "test1").urlPattern(urlProfile2);
        result = DataSource.uriToXref((String)url1);
        Assert.assertEquals((Object)url1, (Object)result.getUrl());
        result = DataSource.uriToXref((String)url2);
        Assert.assertEquals((Object)expResult, (Object)result);
        Assert.assertEquals((Object)url2, (Object)result.getUrl());
    }

    @Test
    public void testGetByURLSeveralURLWithPostFix() throws Exception {
        String urlProfile = "http://www.example8.com/$id/more";
        String url = "http://www.example8.com/12345/more";
        DataSource expResult = DataSource.register("test1", "test1").urlPattern(urlProfile).asDataSource();
        DataSource.register("testy1", "testy1").urlPattern("http://www.example8.org/Pizza#$id/more").asDataSource();
        DataSource.register("testy2", "testy2").urlPattern("http://www.example8.org/Bread#$id/more").asDataSource();
        DataSource.register("testy3", "testy3").urlPattern("http://www.example8.org/$id#more").asDataSource();
        DataSource.register("testy4", "testy4").urlPattern("http://www.example8.org/$id/more").asDataSource();
        DataSource.register("testy5", "testy5").urlPattern("http://www.example8.org/$id:more").asDataSource();
        DataSource result = DataSource.getByURL((String)url);
        Assert.assertEquals((Object)expResult, (Object)result);
    }

    @Test
    public void testByURLDirectly() {
        String urlPattern = "http://www.example10.com/$id";
        DataSource expected = DataSource.getByURLPattern((String)urlPattern);
        DataSource result = DataSource.getByURLPattern((String)urlPattern);
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testByURLDirectlyDifferentPatterns() {
        String urlPattern1 = "http://www.example11.com/Pizza/$id";
        String urlPattern2 = "http://www.example11.com/bread/$id";
        DataSource expected = DataSource.getByURLPattern((String)urlPattern1);
        DataSource result = DataSource.getByURLPattern((String)urlPattern2);
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)expected.equals(result));
    }

    @Test
    public void testByURLDirectlyWithPostFix() {
        String urlPattern = "http://www.example12.com/$id/More";
        DataSource expected = DataSource.getByURLPattern((String)urlPattern);
        DataSource result = DataSource.getByURLPattern((String)urlPattern);
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testByURLDirectlyDifferentPatternsWithPostFix() {
        String urlPattern1 = "http://www.example13.com/Pizza/$id/more";
        String urlPattern2 = "http://www.example13.com/bread/$id/more";
        DataSource expected = DataSource.getByURLPattern((String)urlPattern1);
        DataSource result = DataSource.getByURLPattern((String)urlPattern2);
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)expected.equals(result));
    }

    @Test
    public void testByURLDirectlyPatternsWithDifferentPostFix() {
        String urlPattern1 = "http://www.example14.com/$id/more";
        String urlPattern2 = "http://www.example14.com/$id/fluff";
        DataSource expected = DataSource.getByURLPattern((String)urlPattern1);
        DataSource result = DataSource.getByURLPattern((String)urlPattern2);
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)expected.equals(result));
    }

    public void testNameSpace() throws IDMapperException {
        String nameSpace = "http://www.example15.com/";
        DataSource expResult = DataSource.register("test1", "test1").nameSpace(nameSpace).asDataSource();
        DataSource result = DataSource.getByNameSpace((String)nameSpace);
        Assert.assertEquals((Object)expResult, (Object)result);
        result = DataSource.getByURL((String)(nameSpace + "1234"));
        Assert.assertEquals((Object)expResult, (Object)result);
        result = DataSource.getByURLPattern((String)(nameSpace + "$1d"));
        Assert.assertEquals((Object)expResult, (Object)result);
    }

    public void testByNameSpace() {
        String nameSpace = "http://www.example16.com/";
        DataSource expResult = DataSource.getByNameSpace((String)nameSpace);
        DataSource result = DataSource.getByNameSpace((String)nameSpace);
        Assert.assertEquals((Object)expResult, (Object)result);
        result = DataSource.getByURL((String)(nameSpace + "1234"));
        Assert.assertEquals((Object)expResult, (Object)result);
        result = DataSource.getByURLPattern((String)(nameSpace + "$1d"));
        Assert.assertEquals((Object)expResult, (Object)result);
    }
}

