/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.file;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bridgedb.BridgeDb;
import org.bridgedb.IDMapper;
import org.bridgedb.IDMapperException;
import org.bridgedb.Xref;
import org.bridgedb.file.IDMapperFile;
import org.bridgedb.file.IDMappingReaderFromText;

public class IDMapperText
extends IDMapperFile {
    private final URL url;
    private char[] dataSourceDelimiters;
    private char[] idDelimiters;
    private boolean transitivity;

    public IDMapperText(URL url) throws IDMapperException {
        this(url, new char[]{'\t'});
    }

    public IDMapperText(URL url, char[] dataSourceDelimiters) throws IDMapperException {
        this(url, dataSourceDelimiters, null);
    }

    public IDMapperText(URL url, char[] dataSourceDelimiters, char[] idDelimiters) throws IDMapperException {
        this(url, dataSourceDelimiters, idDelimiters, false);
    }

    public IDMapperText(URL url, char[] dataSourceDelimiters, char[] idDelimiters, boolean transitivity) throws IDMapperException {
        super(new IDMappingReaderFromText(url, dataSourceDelimiters, idDelimiters));
        this.url = url;
        this.dataSourceDelimiters = dataSourceDelimiters;
        this.idDelimiters = idDelimiters;
        this.setTransitivity(transitivity);
    }

    @Override
    public Set<Xref> freeSearch(String text, int limit) throws IDMapperException {
        throw new UnsupportedOperationException();
    }

    public void setTransitivity(boolean transitivity) {
        this.transitivity = transitivity;
        ((IDMappingReaderFromText)this.reader).setTransitivity(transitivity);
    }

    public boolean getTransitivity() {
        return this.transitivity;
    }

    public URL getURL() {
        return this.url;
    }

    public char[] getDataSourceDelimiters() {
        return this.dataSourceDelimiters;
    }

    public char[] getIDDelimiters() {
        return this.idDelimiters;
    }

    public void setDataSourceDelimiters(char[] dataSourceDelimiters) {
        ((IDMappingReaderFromText)this.getIDMappingReader()).setDataSourceDelimiters(dataSourceDelimiters);
        this.dataSourceDelimiters = dataSourceDelimiters;
    }

    public void setIDDelimiters(char[] idDelimiters) {
        ((IDMappingReaderFromText)this.getIDMappingReader()).setIDDelimiters(idDelimiters);
        this.idDelimiters = idDelimiters;
    }

    public String toString() {
        return this.url.toString();
    }

    static {
        BridgeDb.register("idmapper-text", new Driver());
    }

    private static final class Driver
    implements org.bridgedb.Driver {
        private Driver() {
        }

        @Override
        public IDMapper connect(String location) throws IDMapperException {
            String path = null;
            char[] dssep = null;
            char[] idsep = null;
            boolean transitivity = false;
            int idx = location.indexOf("@");
            if (idx <= 0) {
                path = location;
                idsep = new char[]{','};
                dssep = new char[]{'\t'};
            } else if (idx > location.indexOf(":/")) {
                path = location;
            } else {
                String prefixTran;
                while (idx > 0 && location.charAt(idx - 1) == '\\') {
                    idx = location.indexOf(idx + 1);
                }
                if (idx == -1) {
                    throw new IDMapperException("Wrong link format!");
                }
                if (idx == location.length() - 1) {
                    throw new IDMapperException("Empty address!");
                }
                path = location.substring(idx + 1);
                String config = location.substring(0, idx) + ",";
                String tran = config.substring((idx = config.indexOf(prefixTran = "transitivity=")) + prefixTran.length());
                if (tran.toLowerCase().startsWith("true")) {
                    transitivity = true;
                } else if (tran.toLowerCase().startsWith("false")) {
                    transitivity = false;
                } else {
                    throw new IDMapperException("transivity can only be true or false");
                }
                dssep = this.parseConfig(config, "dssep");
                idsep = this.parseConfig(config, "idsep");
            }
            try {
                return new IDMapperText(new URL(path), dssep, idsep, transitivity);
            }
            catch (MalformedURLException ex) {
                throw new IDMapperException(ex);
            }
        }

        private char[] parseConfig(String config, String head) {
            HashSet<Character> delimiters = new HashSet<Character>();
            Pattern p = Pattern.compile(head + "=(.|\\t|\\@),", 2);
            Matcher m = p.matcher(config);
            while (m.find()) {
                String sep = m.group(1);
                if (sep.equalsIgnoreCase("\\t")) {
                    sep = "\t";
                } else if (sep.equalsIgnoreCase("\\@")) {
                    sep = "@";
                }
                delimiters.add(Character.valueOf(sep.charAt(0)));
            }
            int nsep = delimiters.size();
            if (nsep == 0) {
                return null;
            }
            char[] ret = new char[nsep];
            int isep = 0;
            Iterator i$ = delimiters.iterator();
            while (i$.hasNext()) {
                char c = ((Character)i$.next()).charValue();
                ret[isep++] = c;
            }
            return ret;
        }
    }
}

