## ----style, echo = FALSE, results = 'asis'-------------------------------
BiocStyle::markdown(css.files = "my.css")

## ----code, echo = FALSE--------------------------------------------------
code <- function(...) {
    cat(paste(..., sep = "\n"))
}

code2 <- function(...) {
    cat(paste("```markdown", ..., "\n", "```", sep = "\n"))
}

## ----, echo = FALSE , results = 'asis'-----------------------------------
code("```{r style, echo = FALSE, results = 'asis'}",
     "BiocStyle::markdown()",
     "```")

## ----macro, echo=FALSE---------------------------------------------------
macro <- function(name, pkg, description)
    sprintf('`` `r %s("%s")` `` %s %s', name, pkg,
            description, do.call(name, list(pkg)))

## ----figure, fig.width=4.0, fig.height=4.4-------------------------------
v = seq(0, 60i, length = 1000)
plot(abs(v)*exp(v), type = "l", col = "Royalblue")

## ----, echo = FALSE, results = 'asis'------------------------------------
code("```{r style, echo = FALSE, results = 'asis'}",
     "BiocStyle::markdown(css.files = c('my.css'))",
     "```")

## ----, echo = FALSE , results = 'asis'-----------------------------------
code("```{.sh}",
     "ls",
     "```")

## ----, echo = FALSE , results = 'asis'-----------------------------------
cat(BiocStyle:::.print.file("my.css"))

## ----, echo = FALSE , results = 'asis'-----------------------------------
cat("<!--", "rmarkdown", "v1", "-->")

## ----sessionInfo, echo=FALSE---------------------------------------------
sessionInfo()

