### R code from vignette source 'BEclear.Rnw'

###################################################
### code chunk number 1: BEclear.Rnw:5-6
###################################################
options(width=65)


###################################################
### code chunk number 2: BEclear.Rnw:43-49
###################################################
library(BEclear)
data(BEclearData)

ex.data[1:10,1:5]

ex.samples[1:10,]


###################################################
### code chunk number 3: BEclear.Rnw:70-72
###################################################
pvals <- calcPvalues(ex.data, ex.samples, parallel=TRUE,
        cores=4, adjusted=TRUE, method="fdr")


###################################################
### code chunk number 4: BEclear.Rnw:76-77
###################################################
pvals[210:220,5:8]


###################################################
### code chunk number 5: BEclear.Rnw:96-100
###################################################
mdifs <- calcMedians(ex.data, ex.samples, parallel=TRUE,
        cores=4)

mdifs[210:220,5:8]


###################################################
### code chunk number 6: BEclear.Rnw:109-110
###################################################
summary <- calcSummary(medians=mdifs, pvalues=pvals)


###################################################
### code chunk number 7: BEclear.Rnw:116-117
###################################################
summary[1:10,]


###################################################
### code chunk number 8: BEclear.Rnw:125-126
###################################################
summary[summary$batch != "b136",]


###################################################
### code chunk number 9: BEclear.Rnw:135-138
###################################################
score <- calcScore(ex.data, ex.samples, summary, dir=getwd())

score


###################################################
### code chunk number 10: BEclear.Rnw:152-155
###################################################
makeBoxplot(ex.data, ex.samples, score, bySamples=TRUE,
        col="standard", main="Example data", xlab="Batch",
        ylab="Beta value", scoreCol=TRUE)


###################################################
### code chunk number 11: BEclear.Rnw:167-168
###################################################
cleared.data <- clearBEgenes(ex.data, ex.samples, summary)


###################################################
### code chunk number 12: BEclear.Rnw:175-176
###################################################
counted <- countValuesToPredict(cleared.data)


###################################################
### code chunk number 13: BEclear.Rnw:186-189 (eval = FALSE)
###################################################
## corrected.data <- BEclear(cleared.data, parallel=TRUE,
##         cores=4, rowBlockSize=60, colBlockSize=60,
##         epochs=50, outputFormat="RData", dir=getwd())


###################################################
### code chunk number 14: BEclear.Rnw:194-197 (eval = FALSE)
###################################################
## makeBoxplot(corrected.data, ex.samples, score, bySamples=TRUE,
##         col="standard", main="Corrected example data",
##         xlab="Batch", ylab="Beta value", scoreCol=FALSE)


###################################################
### code chunk number 15: BEclear.Rnw:217-221 (eval = FALSE)
###################################################
## result <- correctBatchEffect(ex.data, ex.samples,
##         parallel=TRUE, cores=4, adjusted=TRUE,
##         method="fdr", rowBlockSize=60, colBlockSize=60,
##         epochs=50, outputFormat="RData", dir=getwd())


