### R code from vignette source 'Fletcher2013b.Rnw'

###################################################
### code chunk number 1: Ropts
###################################################
options(width=70)


###################################################
### code chunk number 2: Load DE gene lists
###################################################
  library(Fletcher2013b)
  sigt <- Fletcher2013pipeline.deg(what="Exp1",idtype="entrez")
  MRA1 <- Fletcher2013pipeline.mra1st(hits=sigt$E2FGF10, verbose=FALSE)
  MRA1


###################################################
### code chunk number 3: Run MRA analysis (eval = FALSE)
###################################################
##   MRA2 <- Fletcher2013pipeline.mra2nd(hits=sigt$E2FGF10)
##   MRA3 <- Fletcher2013pipeline.mraNormals(hits=sigt$E2FGF10)
##   MRA4 <- Fletcher2013pipeline.mraTALL(hits=sigt$E2FGF10)


###################################################
### code chunk number 4: Compute FGFR2 master regulators (eval = FALSE)
###################################################
##   masters <- Fletcher2013pipeline.masters()
##   Fletcher2013mra.consensus()


###################################################
### code chunk number 5: MRA aggrement among FGFR2 signatures for metabric cohort I (eval = FALSE)
###################################################
##   Fletcher2013mra.agreement.cohort1()


###################################################
### code chunk number 6: MRA aggrement among cohorts (eval = FALSE)
###################################################
##   Fletcher2013mra.agreement.exp1()
##   Fletcher2013mra.agreement.exp2()
##   Fletcher2013mra.agreement.exp3()


###################################################
### code chunk number 7: Plot regulons from master regulators (eval = FALSE)
###################################################
##   Fletcher2013pipeline.consensusnet()


###################################################
### code chunk number 8: Plot overlap among regulons (eval = FALSE)
###################################################
##   Fletcher2013mra.heatmap1()
##   Fletcher2013mra.heatmap2()


###################################################
### code chunk number 9: Plot enrichment map (eval = FALSE)
###################################################
##   Fletcher2013pipeline.enrichmap()


###################################################
### code chunk number 10: GSEA using master regulators (as hits) vs. FGFR2 signatures (as phenotype) (eval = FALSE)
###################################################
##   Fletcher2013gsea.regulons(what="Exp1")
##   Fletcher2013gsea.regulons(what="Exp2")
##   Fletcher2013gsea.regulons(what="Exp3")


###################################################
### code chunk number 11: Run synergy shadow and overlap analyses for master regulators (eval = FALSE)
###################################################
##   Fletcher2013pipeline.synergyShadow()


###################################################
### code chunk number 12: Plot motif analysis (eval = FALSE)
###################################################
##   Fletcher2013pipeline.motifs()


###################################################
### code chunk number 13: Plot chipseq analysis (eval = FALSE)
###################################################
##   Fletcher2013pipeline.chipseq(what="SPDEF")


###################################################
### code chunk number 14: MRA analysis using siRNA data (siESR1..siSPDEF..siPTTG1) (eval = FALSE)
###################################################
##   siESR1  <- Fletcher2013pipeline.siRNA(what="siESR1")
##   siSPDEF <- Fletcher2013pipeline.siRNA(what="siSPDEF")
##   siPTTG1 <- Fletcher2013pipeline.siRNA(what="siPTTG1") 


###################################################
### code chunk number 15: MRA analysis using meta PCNA signature (eval = FALSE)
###################################################
##   data(miscellaneous)
##   mPCNAmra <- Fletcher2013pipeline.mra1st(hits=metaPCNA, idtype="entrez", 
##                                           pAdjustMethod="BH", ntop=-1) 


###################################################
### code chunk number 16: Session information
###################################################
print(sessionInfo(), locale=FALSE)


