datacache <- new.env(hash=TRUE, parent=emptyenv())

zebrafish <- function() showQCData("zebrafish", datacache)
zebrafish_dbconn <- function() dbconn(datacache)
zebrafish_dbfile <- function() dbfile(datacache)
zebrafish_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
zebrafish_dbInfo <- function() dbInfo(datacache)

zebrafishORGANISM <- "Danio rerio"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "zebrafish.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ChipDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("ZEBRAFISHCHIP_DB", "zebrafish", "chip zebrafish", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("zebrafish.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(zebrafish_dbconn())
}

