\name{reactomePATHID2EXTID}
\alias{reactomePATHID2EXTID}
\title{An annotation data object that maps Reactome pathway identifiers to Entrez Gene identifiers.}
\description{
  reactomePATHID2EXTID maps Reactome pathway identifiers to Entrez Gene identifiers   
}
\details{
  This is an R object containing key and value pairs. Keys are
  Reactome pathway identifiers and values are Entrez Gene identifiers. Values are
  vectors of length 1 or greater depending on whether a pathway identifier can
  be mapped to one or more Entrez Gene identifiers. 

  Reactome pathway identifiers are the identifiers used by Reactome for various
  pathways.

  Mappings between Reactome pathway identifiers and pathway names can be obtained
  through another annotation data object named reactomePATHID2NAME. 

  Mappings were based on data provided by: Reactome 
  http://www.reactome.org/download/current/sql.gz & http://www.reactome.org/download/current/sql_dn.gz
  With a date stamp from the source of: 2010-Dec-21

}
\references{
\url{http://www.reactome.org/}
}
\examples{
	xx <- as.list(reactomePATHID2EXTID)
	if(length(xx) > 0){
		# Get the value of the first key
		xx[[1]]
		# Get the values for multiget for a few keys
		if(length(xx) >= 3){
			xx[1:3]
		}
	}
}
\keyword{datasets}

