datacache <- new.env(hash=TRUE, parent=emptyenv())

pedbarrayv9 <- function() showQCData("pedbarrayv9", datacache)
pedbarrayv9_dbconn <- function() dbconn(datacache)
pedbarrayv9_dbfile <- function() dbfile(datacache)
pedbarrayv9_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
pedbarrayv9_dbInfo <- function() dbInfo(datacache)

pedbarrayv9ORGANISM <- "Homo sapiens"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "pedbarrayv9.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ChipDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("HUMANCHIP_DB", "pedbarrayv9", "chip pedbarrayv9", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("pedbarrayv9.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(pedbarrayv9_dbconn())
}

