datacache <- new.env(hash=TRUE, parent=emptyenv())

mguatlas5k <- function() showQCData("mguatlas5k", datacache)
mguatlas5k_dbconn <- function() dbconn(datacache)
mguatlas5k_dbfile <- function() dbfile(datacache)
mguatlas5k_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
mguatlas5k_dbInfo <- function() dbInfo(datacache)

mguatlas5kORGANISM <- "Mus musculus"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "mguatlas5k.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ChipDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("MOUSECHIP_DB", "mguatlas5k", "chip mguatlas5k", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("mguatlas5k.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(mguatlas5k_dbconn())
}

