datacache <- new.env(hash=TRUE, parent=emptyenv())

mgu74c <- function() showQCData("mgu74c", datacache)
mgu74c_dbconn <- function() dbconn(datacache)
mgu74c_dbfile <- function() dbfile(datacache)
mgu74c_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
mgu74c_dbInfo <- function() dbInfo(datacache)

mgu74cORGANISM <- "Mus musculus"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "mgu74c.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ChipDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("MOUSECHIP_DB", "mgu74c", "chip mgu74c", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("mgu74c.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(mgu74c_dbconn())
}

