datacache <- new.env(hash=TRUE, parent=emptyenv())

hom.Rn.inp <- function() showQCData("hom.Rn.inp", datacache)
hom.Rn.inp_dbconn <- function() dbconn(datacache)
hom.Rn.inp_dbfile <- function() dbfile(datacache)
hom.Rn.inp_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
hom.Rn.inp_dbInfo <- function() dbInfo(datacache)

hom.Rn.inpORGANISM <- "Rattus norvegicus"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "hom.Rn.inp.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"InparanoidDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)

    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("INPARANOID_DB", "hom.Rn.inp", "Rat", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("hom.Rn.inp.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(hom.Rn.inp_dbconn())
}

