\name{hom.Mm.inpHOMSA}
\alias{hom.Mm.inpACYPI}
\alias{hom.Mm.inpAEDAE}
\alias{hom.Mm.inpANOGA}
\alias{hom.Mm.inpAPIME}
\alias{hom.Mm.inpARATH}
\alias{hom.Mm.inpASPFU}
\alias{hom.Mm.inpBATDE}
\alias{hom.Mm.inpBOMMO}
\alias{hom.Mm.inpBOSTA}
\alias{hom.Mm.inpBRAFL}
\alias{hom.Mm.inpBRUMA}
\alias{hom.Mm.inpCAEBRE}
\alias{hom.Mm.inpCAEBR}
\alias{hom.Mm.inpCAEEL}
\alias{hom.Mm.inpCAEJA}
\alias{hom.Mm.inpCAERE}
\alias{hom.Mm.inpCANAL}
\alias{hom.Mm.inpCANGL}
\alias{hom.Mm.inpCANFA}
\alias{hom.Mm.inpCAPSP}
\alias{hom.Mm.inpCAVPO}
\alias{hom.Mm.inpCHLRE}
\alias{hom.Mm.inpCIOIN}
\alias{hom.Mm.inpCIOSA}
\alias{hom.Mm.inpCOCIM}
\alias{hom.Mm.inpCOPCI}
\alias{hom.Mm.inpCRYNE}
\alias{hom.Mm.inpCRYHO}
\alias{hom.Mm.inpCRYPA}
\alias{hom.Mm.inpCULPI}
\alias{hom.Mm.inpCYAME}
\alias{hom.Mm.inpDANRE}
\alias{hom.Mm.inpDAPPU}
\alias{hom.Mm.inpDEBHA}
\alias{hom.Mm.inpDICDI}
\alias{hom.Mm.inpDROAN}
\alias{hom.Mm.inpDROGR}
\alias{hom.Mm.inpDROME}
\alias{hom.Mm.inpDROMO}
\alias{hom.Mm.inpDROPS}
\alias{hom.Mm.inpDROVI}
\alias{hom.Mm.inpDROWI}
\alias{hom.Mm.inpENTHI}
\alias{hom.Mm.inpEQUCA}
\alias{hom.Mm.inpESCCO}
\alias{hom.Mm.inpFUSGR}
\alias{hom.Mm.inpGALGA}
\alias{hom.Mm.inpGASAC}
\alias{hom.Mm.inpGIALA}
\alias{hom.Mm.inpHELRO}
\alias{hom.Mm.inpHOMSA}
\alias{hom.Mm.inpIXOSC}
\alias{hom.Mm.inpKLULA}
\alias{hom.Mm.inpLEIMA}
\alias{hom.Mm.inpLOTGI}
\alias{hom.Mm.inpMACMU}
\alias{hom.Mm.inpMAGGR}
\alias{hom.Mm.inpMONDO}
\alias{hom.Mm.inpMONBR}
\alias{hom.Mm.inpMUSMU}
\alias{hom.Mm.inpNASVI}
\alias{hom.Mm.inpNEMVE}
\alias{hom.Mm.inpNEUCR}
\alias{hom.Mm.inpORNAN}
\alias{hom.Mm.inpORYSA}
\alias{hom.Mm.inpORYLA}
\alias{hom.Mm.inpOSTTA}
\alias{hom.Mm.inpPANTR}
\alias{hom.Mm.inpPEDPA}
\alias{hom.Mm.inpPHYPA}
\alias{hom.Mm.inpPHYRA}
\alias{hom.Mm.inpPHYSO}
\alias{hom.Mm.inpPLAFA}
\alias{hom.Mm.inpPLAVI}
\alias{hom.Mm.inpPONPY}
\alias{hom.Mm.inpPOPTR}
\alias{hom.Mm.inpPRIPA}
\alias{hom.Mm.inpPUCGR}
\alias{hom.Mm.inpRATNO}
\alias{hom.Mm.inpRHIOR}
\alias{hom.Mm.inpSACCE}
\alias{hom.Mm.inpSCHMA}
\alias{hom.Mm.inpSCHPO}
\alias{hom.Mm.inpSCLSC}
\alias{hom.Mm.inpSORBI}
\alias{hom.Mm.inpSTANO}
\alias{hom.Mm.inpSTRPU}
\alias{hom.Mm.inpTAKRU}
\alias{hom.Mm.inpTETTH}
\alias{hom.Mm.inpTETNI}
\alias{hom.Mm.inpTHAPS}
\alias{hom.Mm.inpTHEAN}
\alias{hom.Mm.inpTHEPA}
\alias{hom.Mm.inpTRICA}
\alias{hom.Mm.inpTRIVA}
\alias{hom.Mm.inpTRIAD}
\alias{hom.Mm.inpTRYCR}
\alias{hom.Mm.inpUSTMA}
\alias{hom.Mm.inpXENTR}
\alias{hom.Mm.inpYARLI}
\title{Map between IDs for genes in one organism to their predicted
  paralogs in another}
\description{ 
  A map of this type is an R object that provides mappings between
  identifiers for genes in the package organism and their predicted
  paralogs in the map that the organism is named after.  So for example,
  if the inparanoid package is the human package, then the
  hom.Mm.inpRATNO map would provide mappings between human and rat.
}
\details{
    Mappings between gene identifiers and their paralogs as predicted by
    the Inparanoid algorithm.  The map filters out paralogs that have an
    Inparanoid score less than 100%.

    Mappings are normally given from the ID of the organism in the
    package to the IDs of the organism listed in the map name.

    Reversal can be made of ANY map by using the function revmap (see
    examples below).

    Names for these maps are done in the "INPARANOID style" which means
    that they are normally the 1st three letters of the genus followed
    by the 1st two letters of the species.  For example: "Mus musculus"
    becomes "MUSMU", "Homo sapiens" becomes "HOMSA", "Monodelphis
    domestica" becomes "MONDO" etc. This means that for most of these
    organisms it will be possible to easily guess the abbreviations
    used.  An exception may occur in the future if a new model organism
    has a very similar genus and species name to an existing one.
}
\references{
\url{http://inparanoid.sbc.su.se/download/current/sqltables}
}
\examples{
        x <- hom.Mm.inpAPIME
        # Get honeybee IDs that are paralogous to the pkg IDs
        mapped_IDs <- mappedkeys(x)
        # Convert to a list
        xx <- as.list(x[mapped_IDs])
        if(length(xx) > 0) {
          # Get the paralogs for the first five genes
          xx[1:5]
          # Get the first one
          xx[[1]]
        }

        #Now for the reverse map (honeybee IDs back to pkg paralog)
        x <- revmap(hom.Mm.inpAPIME)
        mapped_IDs <- mappedkeys(x)
        # Convert to a list
        xx <- as.list(x[mapped_IDs])
        if(length(xx) > 0) {
          # Get the paralogs for the first five IDs
          xx[1:5]
          # Get the first one
          xx[[1]]
        }         

    \dontrun{
        #For the most common organisms, we try to ensure that you can
        #map back to an Entrez Gene ID by providing you with necessary
        #maps in the related organism based annotation packages.  The
        #following example shows how to get from an Entrez Gene ID for
        #Human to Entrez Gene IDs for Mouse even though inparanoid does
        #not map to Entrez Gene IDs for either of these species.

        #You will have to include the appropriate packages for
        #humans:
        library("org.Hs.eg.db")
        #and for mouse:
        library("org.Mm.eg.db")
        #And of course you will need the inparanoid package:
        library("hom.Hs.inp.db")

        #Start with some Human Entrez Gene IDs
        humanEGIds <- c("4488","4487")

        #Inparanoid uses ensembl protein IDs so start with
        #those. Notice that there will be many protein IDs returned for
        #a typical gene since there are many possible translations.
        humanProtIds <- mget(humanEGIds,org.Hs.egENSEMBLPROT)

        #Map the IDs that we can from inparanoid. Notice that by design,
        #inparanoid only represents each gene product with a single
        #translation product. Therefore your list could slim down a lot
        #during this step.  Also, if the thing you are trying to match
        #up at this step has less than 100\% seed status, you will not
        #find it in this step.
        rawMouseProtIds <- mget(unlist(humanProtIds),hom.Hs.inpMUSMU,ifnotfound=NA)
        #This also means that we need to clean up the NAs from our result
        mouseProtIds <- rawMouseProtIds[!is.na(rawMouseProtIds)]

        #Then use the mouse organism based packages to convert these IDs
        #back to an Entrez Gene ID again (this time for mouse). 
        mouseEGIds <- mget(unlist(mouseProtIds),
                           org.Mm.egENSEMBLPROT2EG,ifnotfound=NA)
        #Now go ahead and have a look at the output
        mouseEGIds
    }

}
\keyword{datasets}

