\name{hom.Hs.inpHOMSA}
\alias{hom.Hs.inpACYPI}
\alias{hom.Hs.inpAEDAE}
\alias{hom.Hs.inpANOGA}
\alias{hom.Hs.inpAPIME}
\alias{hom.Hs.inpARATH}
\alias{hom.Hs.inpASPFU}
\alias{hom.Hs.inpBATDE}
\alias{hom.Hs.inpBOMMO}
\alias{hom.Hs.inpBOSTA}
\alias{hom.Hs.inpBRAFL}
\alias{hom.Hs.inpBRUMA}
\alias{hom.Hs.inpCAEBRE}
\alias{hom.Hs.inpCAEBR}
\alias{hom.Hs.inpCAEEL}
\alias{hom.Hs.inpCAEJA}
\alias{hom.Hs.inpCAERE}
\alias{hom.Hs.inpCANAL}
\alias{hom.Hs.inpCANGL}
\alias{hom.Hs.inpCANFA}
\alias{hom.Hs.inpCAPSP}
\alias{hom.Hs.inpCAVPO}
\alias{hom.Hs.inpCHLRE}
\alias{hom.Hs.inpCIOIN}
\alias{hom.Hs.inpCIOSA}
\alias{hom.Hs.inpCOCIM}
\alias{hom.Hs.inpCOPCI}
\alias{hom.Hs.inpCRYNE}
\alias{hom.Hs.inpCRYHO}
\alias{hom.Hs.inpCRYPA}
\alias{hom.Hs.inpCULPI}
\alias{hom.Hs.inpCYAME}
\alias{hom.Hs.inpDANRE}
\alias{hom.Hs.inpDAPPU}
\alias{hom.Hs.inpDEBHA}
\alias{hom.Hs.inpDICDI}
\alias{hom.Hs.inpDROAN}
\alias{hom.Hs.inpDROGR}
\alias{hom.Hs.inpDROME}
\alias{hom.Hs.inpDROMO}
\alias{hom.Hs.inpDROPS}
\alias{hom.Hs.inpDROVI}
\alias{hom.Hs.inpDROWI}
\alias{hom.Hs.inpENTHI}
\alias{hom.Hs.inpEQUCA}
\alias{hom.Hs.inpESCCO}
\alias{hom.Hs.inpFUSGR}
\alias{hom.Hs.inpGALGA}
\alias{hom.Hs.inpGASAC}
\alias{hom.Hs.inpGIALA}
\alias{hom.Hs.inpHELRO}
\alias{hom.Hs.inpHOMSA}
\alias{hom.Hs.inpIXOSC}
\alias{hom.Hs.inpKLULA}
\alias{hom.Hs.inpLEIMA}
\alias{hom.Hs.inpLOTGI}
\alias{hom.Hs.inpMACMU}
\alias{hom.Hs.inpMAGGR}
\alias{hom.Hs.inpMONDO}
\alias{hom.Hs.inpMONBR}
\alias{hom.Hs.inpMUSMU}
\alias{hom.Hs.inpNASVI}
\alias{hom.Hs.inpNEMVE}
\alias{hom.Hs.inpNEUCR}
\alias{hom.Hs.inpORNAN}
\alias{hom.Hs.inpORYSA}
\alias{hom.Hs.inpORYLA}
\alias{hom.Hs.inpOSTTA}
\alias{hom.Hs.inpPANTR}
\alias{hom.Hs.inpPEDPA}
\alias{hom.Hs.inpPHYPA}
\alias{hom.Hs.inpPHYRA}
\alias{hom.Hs.inpPHYSO}
\alias{hom.Hs.inpPLAFA}
\alias{hom.Hs.inpPLAVI}
\alias{hom.Hs.inpPONPY}
\alias{hom.Hs.inpPOPTR}
\alias{hom.Hs.inpPRIPA}
\alias{hom.Hs.inpPUCGR}
\alias{hom.Hs.inpRATNO}
\alias{hom.Hs.inpRHIOR}
\alias{hom.Hs.inpSACCE}
\alias{hom.Hs.inpSCHMA}
\alias{hom.Hs.inpSCHPO}
\alias{hom.Hs.inpSCLSC}
\alias{hom.Hs.inpSORBI}
\alias{hom.Hs.inpSTANO}
\alias{hom.Hs.inpSTRPU}
\alias{hom.Hs.inpTAKRU}
\alias{hom.Hs.inpTETTH}
\alias{hom.Hs.inpTETNI}
\alias{hom.Hs.inpTHAPS}
\alias{hom.Hs.inpTHEAN}
\alias{hom.Hs.inpTHEPA}
\alias{hom.Hs.inpTRICA}
\alias{hom.Hs.inpTRIVA}
\alias{hom.Hs.inpTRIAD}
\alias{hom.Hs.inpTRYCR}
\alias{hom.Hs.inpUSTMA}
\alias{hom.Hs.inpXENTR}
\alias{hom.Hs.inpYARLI}
\title{Map between IDs for genes in one organism to their predicted
  paralogs in another}
\description{ 
  A map of this type is an R object that provides mappings between
  identifiers for genes in the package organism and their predicted
  paralogs in the map that the organism is named after.  So for example,
  if the inparanoid package is the human package, then the
  hom.Hs.inpRATNO map would provide mappings between human and rat.
}
\details{
    Mappings between gene identifiers and their paralogs as predicted by
    the Inparanoid algorithm.  The map filters out paralogs that have an
    Inparanoid score less than 100%.

    Mappings are normally given from the ID of the organism in the
    package to the IDs of the organism listed in the map name.

    Reversal can be made of ANY map by using the function revmap (see
    examples below).

    Names for these maps are done in the "INPARANOID style" which means
    that they are normally the 1st three letters of the genus followed
    by the 1st two letters of the species.  For example: "Mus musculus"
    becomes "MUSMU", "Homo sapiens" becomes "HOMSA", "Monodelphis
    domestica" becomes "MONDO" etc. This means that for most of these
    organisms it will be possible to easily guess the abbreviations
    used.  An exception may occur in the future if a new model organism
    has a very similar genus and species name to an existing one.
}
\references{
\url{http://inparanoid.sbc.su.se/download/current/sqltables}
}
\examples{
        x <- hom.Hs.inpAPIME
        # Get honeybee IDs that are paralogous to the pkg IDs
        mapped_IDs <- mappedkeys(x)
        # Convert to a list
        xx <- as.list(x[mapped_IDs])
        if(length(xx) > 0) {
          # Get the paralogs for the first five genes
          xx[1:5]
          # Get the first one
          xx[[1]]
        }

        #Now for the reverse map (honeybee IDs back to pkg paralog)
        x <- revmap(hom.Hs.inpAPIME)
        mapped_IDs <- mappedkeys(x)
        # Convert to a list
        xx <- as.list(x[mapped_IDs])
        if(length(xx) > 0) {
          # Get the paralogs for the first five IDs
          xx[1:5]
          # Get the first one
          xx[[1]]
        }         

    \dontrun{
        #For the most common organisms, we try to ensure that you can
        #map back to an Entrez Gene ID by providing you with necessary
        #maps in the related organism based annotation packages.  The
        #following example shows how to get from an Entrez Gene ID for
        #Human to Entrez Gene IDs for Mouse even though inparanoid does
        #not map to Entrez Gene IDs for either of these species.

        #You will have to include the appropriate packages for
        #humans:
        library("org.Hs.eg.db")
        #and for mouse:
        library("org.Mm.eg.db")
        #And of course you will need the inparanoid package:
        library("hom.Hs.inp.db")

        #Start with some Human Entrez Gene IDs
        humanEGIds <- c("4488","4487")

        #Inparanoid uses ensembl protein IDs so start with
        #those. Notice that there will be many protein IDs returned for
        #a typical gene since there are many possible translations.
        humanProtIds <- mget(humanEGIds,org.Hs.egENSEMBLPROT)

        #Map the IDs that we can from inparanoid. Notice that by design,
        #inparanoid only represents each gene product with a single
        #translation product. Therefore your list could slim down a lot
        #during this step.  Also, if the thing you are trying to match
        #up at this step has less than 100\% seed status, you will not
        #find it in this step.
        rawMouseProtIds <- mget(unlist(humanProtIds),hom.Hs.inpMUSMU,ifnotfound=NA)
        #This also means that we need to clean up the NAs from our result
        mouseProtIds <- rawMouseProtIds[!is.na(rawMouseProtIds)]

        #Then use the mouse organism based packages to convert these IDs
        #back to an Entrez Gene ID again (this time for mouse). 
        mouseEGIds <- mget(unlist(mouseProtIds),
                           org.Mm.egENSEMBLPROT2EG,ifnotfound=NA)
        #Now go ahead and have a look at the output
        mouseEGIds
    }

}
\keyword{datasets}

