\name{hom.Dr.inpHOMSA}
\alias{hom.Dr.inpACYPI}
\alias{hom.Dr.inpAEDAE}
\alias{hom.Dr.inpANOGA}
\alias{hom.Dr.inpAPIME}
\alias{hom.Dr.inpARATH}
\alias{hom.Dr.inpASPFU}
\alias{hom.Dr.inpBATDE}
\alias{hom.Dr.inpBOMMO}
\alias{hom.Dr.inpBOSTA}
\alias{hom.Dr.inpBRAFL}
\alias{hom.Dr.inpBRUMA}
\alias{hom.Dr.inpCAEBRE}
\alias{hom.Dr.inpCAEBR}
\alias{hom.Dr.inpCAEEL}
\alias{hom.Dr.inpCAEJA}
\alias{hom.Dr.inpCAERE}
\alias{hom.Dr.inpCANAL}
\alias{hom.Dr.inpCANGL}
\alias{hom.Dr.inpCANFA}
\alias{hom.Dr.inpCAPSP}
\alias{hom.Dr.inpCAVPO}
\alias{hom.Dr.inpCHLRE}
\alias{hom.Dr.inpCIOIN}
\alias{hom.Dr.inpCIOSA}
\alias{hom.Dr.inpCOCIM}
\alias{hom.Dr.inpCOPCI}
\alias{hom.Dr.inpCRYNE}
\alias{hom.Dr.inpCRYHO}
\alias{hom.Dr.inpCRYPA}
\alias{hom.Dr.inpCULPI}
\alias{hom.Dr.inpCYAME}
\alias{hom.Dr.inpDANRE}
\alias{hom.Dr.inpDAPPU}
\alias{hom.Dr.inpDEBHA}
\alias{hom.Dr.inpDICDI}
\alias{hom.Dr.inpDROAN}
\alias{hom.Dr.inpDROGR}
\alias{hom.Dr.inpDROME}
\alias{hom.Dr.inpDROMO}
\alias{hom.Dr.inpDROPS}
\alias{hom.Dr.inpDROVI}
\alias{hom.Dr.inpDROWI}
\alias{hom.Dr.inpENTHI}
\alias{hom.Dr.inpEQUCA}
\alias{hom.Dr.inpESCCO}
\alias{hom.Dr.inpFUSGR}
\alias{hom.Dr.inpGALGA}
\alias{hom.Dr.inpGASAC}
\alias{hom.Dr.inpGIALA}
\alias{hom.Dr.inpHELRO}
\alias{hom.Dr.inpHOMSA}
\alias{hom.Dr.inpIXOSC}
\alias{hom.Dr.inpKLULA}
\alias{hom.Dr.inpLEIMA}
\alias{hom.Dr.inpLOTGI}
\alias{hom.Dr.inpMACMU}
\alias{hom.Dr.inpMAGGR}
\alias{hom.Dr.inpMONDO}
\alias{hom.Dr.inpMONBR}
\alias{hom.Dr.inpMUSMU}
\alias{hom.Dr.inpNASVI}
\alias{hom.Dr.inpNEMVE}
\alias{hom.Dr.inpNEUCR}
\alias{hom.Dr.inpORNAN}
\alias{hom.Dr.inpORYSA}
\alias{hom.Dr.inpORYLA}
\alias{hom.Dr.inpOSTTA}
\alias{hom.Dr.inpPANTR}
\alias{hom.Dr.inpPEDPA}
\alias{hom.Dr.inpPHYPA}
\alias{hom.Dr.inpPHYRA}
\alias{hom.Dr.inpPHYSO}
\alias{hom.Dr.inpPLAFA}
\alias{hom.Dr.inpPLAVI}
\alias{hom.Dr.inpPONPY}
\alias{hom.Dr.inpPOPTR}
\alias{hom.Dr.inpPRIPA}
\alias{hom.Dr.inpPUCGR}
\alias{hom.Dr.inpRATNO}
\alias{hom.Dr.inpRHIOR}
\alias{hom.Dr.inpSACCE}
\alias{hom.Dr.inpSCHMA}
\alias{hom.Dr.inpSCHPO}
\alias{hom.Dr.inpSCLSC}
\alias{hom.Dr.inpSORBI}
\alias{hom.Dr.inpSTANO}
\alias{hom.Dr.inpSTRPU}
\alias{hom.Dr.inpTAKRU}
\alias{hom.Dr.inpTETTH}
\alias{hom.Dr.inpTETNI}
\alias{hom.Dr.inpTHAPS}
\alias{hom.Dr.inpTHEAN}
\alias{hom.Dr.inpTHEPA}
\alias{hom.Dr.inpTRICA}
\alias{hom.Dr.inpTRIVA}
\alias{hom.Dr.inpTRIAD}
\alias{hom.Dr.inpTRYCR}
\alias{hom.Dr.inpUSTMA}
\alias{hom.Dr.inpXENTR}
\alias{hom.Dr.inpYARLI}
\title{Map between IDs for genes in one organism to their predicted
  paralogs in another}
\description{ 
  A map of this type is an R object that provides mappings between
  identifiers for genes in the package organism and their predicted
  paralogs in the map that the organism is named after.  So for example,
  if the inparanoid package is the human package, then the
  hom.Dr.inpRATNO map would provide mappings between human and rat.
}
\details{
    Mappings between gene identifiers and their paralogs as predicted by
    the Inparanoid algorithm.  The map filters out paralogs that have an
    Inparanoid score less than 100%.

    Mappings are normally given from the ID of the organism in the
    package to the IDs of the organism listed in the map name.

    Reversal can be made of ANY map by using the function revmap (see
    examples below).

    Names for these maps are done in the "INPARANOID style" which means
    that they are normally the 1st three letters of the genus followed
    by the 1st two letters of the species.  For example: "Mus musculus"
    becomes "MUSMU", "Homo sapiens" becomes "HOMSA", "Monodelphis
    domestica" becomes "MONDO" etc. This means that for most of these
    organisms it will be possible to easily guess the abbreviations
    used.  An exception may occur in the future if a new model organism
    has a very similar genus and species name to an existing one.
}
\references{
\url{http://inparanoid.sbc.su.se/download/current/sqltables}
}
\examples{
        x <- hom.Dr.inpAPIME
        # Get honeybee IDs that are paralogous to the pkg IDs
        mapped_IDs <- mappedkeys(x)
        # Convert to a list
        xx <- as.list(x[mapped_IDs])
        if(length(xx) > 0) {
          # Get the paralogs for the first five genes
          xx[1:5]
          # Get the first one
          xx[[1]]
        }

        #Now for the reverse map (honeybee IDs back to pkg paralog)
        x <- revmap(hom.Dr.inpAPIME)
        mapped_IDs <- mappedkeys(x)
        # Convert to a list
        xx <- as.list(x[mapped_IDs])
        if(length(xx) > 0) {
          # Get the paralogs for the first five IDs
          xx[1:5]
          # Get the first one
          xx[[1]]
        }         

    \dontrun{
        #For the most common organisms, we try to ensure that you can
        #map back to an Entrez Gene ID by providing you with necessary
        #maps in the related organism based annotation packages.  The
        #following example shows how to get from an Entrez Gene ID for
        #Human to Entrez Gene IDs for Mouse even though inparanoid does
        #not map to Entrez Gene IDs for either of these species.

        #You will have to include the appropriate packages for
        #humans:
        library("org.Hs.eg.db")
        #and for mouse:
        library("org.Mm.eg.db")
        #And of course you will need the inparanoid package:
        library("hom.Hs.inp.db")

        #Start with some Human Entrez Gene IDs
        humanEGIds <- c("4488","4487")

        #Inparanoid uses ensembl protein IDs so start with
        #those. Notice that there will be many protein IDs returned for
        #a typical gene since there are many possible translations.
        humanProtIds <- mget(humanEGIds,org.Hs.egENSEMBLPROT)

        #Map the IDs that we can from inparanoid. Notice that by design,
        #inparanoid only represents each gene product with a single
        #translation product. Therefore your list could slim down a lot
        #during this step.  Also, if the thing you are trying to match
        #up at this step has less than 100\% seed status, you will not
        #find it in this step.
        rawMouseProtIds <- mget(unlist(humanProtIds),hom.Hs.inpMUSMU,ifnotfound=NA)
        #This also means that we need to clean up the NAs from our result
        mouseProtIds <- rawMouseProtIds[!is.na(rawMouseProtIds)]

        #Then use the mouse organism based packages to convert these IDs
        #back to an Entrez Gene ID again (this time for mouse). 
        mouseEGIds <- mget(unlist(mouseProtIds),
                           org.Mm.egENSEMBLPROT2EG,ifnotfound=NA)
        #Now go ahead and have a look at the output
        mouseEGIds
    }

}
\keyword{datasets}

