datacache <- new.env(hash=TRUE, parent=emptyenv())

hom.Dr.inp <- function() showQCData("hom.Dr.inp", datacache)
hom.Dr.inp_dbconn <- function() dbconn(datacache)
hom.Dr.inp_dbfile <- function() dbfile(datacache)
hom.Dr.inp_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
hom.Dr.inp_dbInfo <- function() dbInfo(datacache)

hom.Dr.inpORGANISM <- "Danio rerio"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "hom.Dr.inp.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"InparanoidDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)

    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("INPARANOID_DB", "hom.Dr.inp", "Zebrafish", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("hom.Dr.inp.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(hom.Dr.inp_dbconn())
}

