
\name{hcg110_dbconn}

\alias{hcg110_dbconn}
\alias{hcg110_dbfile}
\alias{hcg110_dbschema}
\alias{hcg110_dbInfo}


\title{Collect information about the package annotation DB}

\description{
  Some convenience functions for getting a connection object to (or collecting
  information about) the package annotation DB.
}

\usage{
  hcg110_dbconn()
  hcg110_dbfile()
  hcg110_dbschema(file="", show.indices=FALSE)
  hcg110_dbInfo()
}

\arguments{
  \item{file}{
    A connection, or a character string naming the file to print to (see
    the \code{file} argument of the \code{\link[base]{cat}} function for
    the details).
  }
  \item{show.indices}{
    The CREATE INDEX statements are not shown by default.
    Use \code{show.indices=TRUE} to get them.
  }
}

\details{
  \code{hcg110_dbconn} returns a connection object to the
  package annotation DB.  IMPORTANT: Don't call
  \code{\link[DBI:dbConnect]{dbDisconnect}} on the connection object
  returned by \code{hcg110_dbconn} or you will break all the
  \code{\link[AnnotationDbi:AnnDbObj-class]{AnnDbObj}} objects defined
  in this package!

  \code{hcg110_dbfile} returns the path (character string) to the
  package annotation DB (this is an SQLite file).

  \code{hcg110_dbschema} prints the schema definition of the
  package annotation DB.

  \code{hcg110_dbInfo} prints other information about the package
  annotation DB.
}

\value{
  \code{hcg110_dbconn}: a DBIConnection object representing an
  open connection to the package annotation DB.

  \code{hcg110_dbfile}: a character string with the path to the
  package annotation DB.

  \code{hcg110_dbschema}: none (invisible \code{NULL}).

  \code{hcg110_dbInfo}: none (invisible \code{NULL}).
}

\seealso{
  \code{\link[DBI:dbSendQuery]{dbGetQuery}},
  \code{\link[DBI:dbConnect]{dbConnect}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbconn}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbfile}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbschema}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbInfo}}
}

\examples{
  ## Count the number of rows in the "probes" table:
  dbGetQuery(hcg110_dbconn(), "SELECT COUNT(*) FROM probes")

  ## The connection object returned by hcg110_dbconn() was
  ## created with:
  dbConnect(SQLite(), dbname=hcg110_dbfile(), cache_size=64000,
  synchronous=0)

  hcg110_dbschema()

  hcg110_dbInfo()
}

\keyword{utilities}
\keyword{datasets}

