datacache <- new.env(hash=TRUE, parent=emptyenv())

celegans <- function() showQCData("celegans", datacache)
celegans_dbconn <- function() dbconn(datacache)
celegans_dbfile <- function() dbfile(datacache)
celegans_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
celegans_dbInfo <- function() dbInfo(datacache)

celegansORGANISM <- "Caenorhabditis elegans"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "celegans.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ChipDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("WORMCHIP_DB", "celegans", "chip celegans", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("celegans.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(celegans_dbconn())
}

