datacache <- new.env(hash=TRUE, parent=emptyenv())

canine2 <- function() showQCData("canine2", datacache)
canine2_dbconn <- function() dbconn(datacache)
canine2_dbfile <- function() dbfile(datacache)
canine2_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
canine2_dbInfo <- function() dbInfo(datacache)

canine2ORGANISM <- "Canis familiaris"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "canine2.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ChipDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("CANINECHIP_DB", "canine2", "chip canine2", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("canine2.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(canine2_dbconn())
}

