datacache <- new.env(hash=TRUE, parent=emptyenv())

PFAM <- function() showQCData("PFAM", datacache)
PFAM_dbconn <- function() dbconn(datacache)
PFAM_dbfile <- function() dbfile(datacache)
PFAM_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
PFAM_dbInfo <- function() dbInfo(datacache)

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "PFAM.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("PFAM_DB", "PFAM", "Human", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("PFAM.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(PFAM_dbconn())
}

