\name{MafDb.ALL.wgs.phase1.release.v3.20101123-package}
\alias{MafDb.ALL.wgs.phase1.release.v3.20101123-package}
\alias{MafDb.ALL.wgs.phase1.release.v3.20101123}
\docType{package}

\title{
Annotation package for minimum allele frequency data from the 1000 Genomes project
}
\description{
This annotation package stores minimum allele frequency (MAF) data values frozen from the 1000 Genomes project. The data is stored in the form of a SQLite database and is loaded automatically in the form of a MafDb object. The name of the exposed object matches the name of the package and part of the filename that contained the data imported into the package. The class definition and methods to access MafDb objects are found in the \code{\link[VariantFiltering]{VariantFiltering}} software package.
}

\format{
  \tabular{ll}{
    \code{\link{MafDb.ALL.wgs.phase1.release.v3.20101123}} \tab MafDb object containing MAF values from the 1000 Genomes project downloaded in October 2013 from \url{ftp://ftp.1000genomes.ebi.ac.uk/vol1/ftp/release/20110521/ALL.wgs.phase1_release_v3.20101123.snps_indels_sv.sites.vcf.gz}. See \code{\link{makeMafDbPackageKG}} for more information on how to update these data. \cr
  }
}

\author{
R. Castelo
}

\seealso{
  \link{makeMafDbPackageKG}
  \link[MafDb.ESP6500SI.V2.SSA137.dbSNP138]{MafDb.ESP6500SI.V2.SSA137.dbSNP138}
  \link[VariantFiltering]{MafDb-class}
  \link[VariantFiltering]{fetchKnownVariantsByID}
  \link[VariantFiltering]{VariantFiltering}
}

\examples{
library(MafDb.ALL.wgs.phase1.release.v3.20101123)

ls("package:MafDb.ALL.wgs.phase1.release.v3.20101123")

MafDb.ALL.wgs.phase1.release.v3.20101123
}

\source{
  The 1000 Genomes Project Consortium. An integrated map of genetic variation
  from 1,092 human genomes. Nature, 491:56-65, 2012.
  (URL: \url{ftp://ftp.1000genomes.ebi.ac.uk}) [October, 2013, accessed]
}

\keyword{package}
\keyword{data}
