\name{Hs6UG171MAPCOUNTS} 

\alias{Hs6UG171MAPCOUNTS}


\title{Number of mapped keys for the maps in package Hs6UG171.db}

\description{
  Hs6UG171MAPCOUNTS provides the "map count" (i.e. the
  count of mapped keys) for each map in package Hs6UG171.db.
}

\details{  
  This "map count" information is precalculated and stored in the
  package annotation DB. This allows some quality control and is used by
  the \code{\link[AnnotationDbi:AnnDbPkg-checker]{checkMAPCOUNTS}}
  function defined in AnnotationDbi to compare and validate different
  methods (like \code{count.mappedkeys(x)} or
  \code{sum(!is.na(as.list(x)))}) for getting the "map count" of a given
  map.
}

\seealso{
  \code{\link[AnnotationDbi:Bimap-keys]{mappedkeys}},
  \code{\link[AnnotationDbi:Bimap-keys]{count.mappedkeys}},
  \code{\link[AnnotationDbi:AnnDbPkg-checker]{checkMAPCOUNTS}}
}

\examples{
  Hs6UG171MAPCOUNTS
  mapnames <- names(Hs6UG171MAPCOUNTS)
  Hs6UG171MAPCOUNTS[mapnames[1]]
  x <- get(mapnames[1])
  sum(!is.na(as.list(x)))
  count.mappedkeys(x)   # much faster!

  ## Check the "map count" of all the maps in package Hs6UG171.db
  checkMAPCOUNTS("Hs6UG171.db")
}

\keyword{datasets}

