### R code from vignette source 'viper.Rnw'

###################################################
### code chunk number 1: viper.Rnw:63-67 (eval = FALSE)
###################################################
## source("http://bioconductor.org/biocLite.R")
## biocLite("mixtools")
## biocLite("bcellViper")
## biocLite("viper")


###################################################
### code chunk number 2: viper.Rnw:72-73
###################################################
library(viper)


###################################################
### code chunk number 3: viper.Rnw:85-88
###################################################
data(bcellViper, package="bcellViper")
adjfile <- system.file("aracne", "bcellaracne.adj", package = "bcellViper")
regul <- aracne2regulon(adjfile, dset, verbose = FALSE)


###################################################
### code chunk number 4: viper.Rnw:90-91
###################################################
print(regul)


###################################################
### code chunk number 5: viper.Rnw:108-109
###################################################
signature <- rowTtest(dset, "description", c("CB", "CC"), "N")


###################################################
### code chunk number 6: viper.Rnw:115-117
###################################################
signature <- (qnorm(signature$p.value/2, lower.tail = FALSE) * 
                sign(signature$statistic))[, 1]


###################################################
### code chunk number 7: viper.Rnw:125-127
###################################################
nullmodel <- ttestNull(dset, "description", c("CB", "CC"), "N", per = 1000,
                       repos = TRUE, verbose = FALSE)


###################################################
### code chunk number 8: viper.Rnw:135-136
###################################################
regulon


###################################################
### code chunk number 9: viper.Rnw:141-142
###################################################
mrs <- msviper(signature, regulon, nullmodel, verbose = FALSE)


###################################################
### code chunk number 10: viper.Rnw:147-148
###################################################
summary(mrs)


###################################################
### code chunk number 11: msviper
###################################################
plot(mrs, cex = .7)


###################################################
### code chunk number 12: viper.Rnw:170-172
###################################################
mrs <- ledge(mrs)
summary(mrs)


###################################################
### code chunk number 13: viper.Rnw:182-184
###################################################
signature <- bootstrapTtest(dset, "description", c("CB", "CC"), "N", verbose = FALSE)
mrs <- msviper(signature, regulon, nullmodel, verbose = FALSE)


###################################################
### code chunk number 14: viper.Rnw:188-189
###################################################
mrs <- bootstrapmsviper(mrs, "mode")


###################################################
### code chunk number 15: bsmsviper
###################################################
plot(mrs, cex = .7)


###################################################
### code chunk number 16: viper.Rnw:210-211
###################################################
mrshadow <- shadow(mrs, regulators = 25, verbose = FALSE)


###################################################
### code chunk number 17: viper.Rnw:216-217
###################################################
summary(mrshadow)


###################################################
### code chunk number 18: viper.Rnw:226-227
###################################################
mrs <- msviperCombinatorial(mrs, regulators = 25, verbose = FALSE)


###################################################
### code chunk number 19: viper.Rnw:231-232
###################################################
mrs <- msviperSynergy(mrs, verbose = FALSE)


###################################################
### code chunk number 20: synmsviper
###################################################
summary(mrs)
plot(mrs, 25, cex = .7)


###################################################
### code chunk number 21: viper.Rnw:254-255
###################################################
vpres <- viper(dset, regulon, verbose = FALSE)


###################################################
### code chunk number 22: viper.Rnw:259-260
###################################################
dim(vpres)


###################################################
### code chunk number 23: viper.Rnw:264-267
###################################################
tmp <- rowTtest(vpres, "description", c("CB", "CC"), "N")
data.frame(Gene = rownames(tmp$p.value), t = round(tmp$statistic, 2),
"p-value" = signif(tmp$p.value, 3))[order(tmp$p.value)[1:10], ]


###################################################
### code chunk number 24: viper.Rnw:277-279
###################################################
vpsig <- viperSignature(dset, "description", "N", verbose = FALSE)
vpres <- viper(vpsig, regulon, verbose = FALSE)


###################################################
### code chunk number 25: euviper
###################################################
pos <- pData(vpres)[["description"]] %in% c("M", "CB", "CC")
d1 <- exprs(vpres)[, pos]
colnames(d1) <- pData(vpres)[["description"]][pos]
dd <- dist(t(d1), method = "euclidean")
heatmap(as.matrix(dd), Rowv = as.dendrogram(hclust(dd, method = "average")), symm = T)


###################################################
### code chunk number 26: viper.Rnw:303-304
###################################################
dd <- signatureDistance(d1, scale. = F)


###################################################
### code chunk number 27: sigviper
###################################################
heatmap(as.matrix(as.dist(dd)), Rowv = as.dendrogram(hclust(as.dist(dd),
method = "average")), symm = T)


