### R code from vignette source 'systemPipeVARseq.Rnw'

###################################################
### code chunk number 1: style
###################################################
BiocStyle::latex(use.unsrturl=FALSE)


###################################################
### code chunk number 2: systemPipeVARseq.Rnw:42-44
###################################################
options(width=95)
unlink("test.db")


###################################################
### code chunk number 3: systemPipeVARseq.Rnw:71-72
###################################################
library(systemPipeR)


###################################################
### code chunk number 4: systemPipeVARseq.Rnw:76-77 (eval = FALSE)
###################################################
## source("systemPipeVARseq_Fct.R")


###################################################
### code chunk number 5: systemPipeVARseq.Rnw:82-85
###################################################
targetspath <- system.file("extdata", "targets.txt", package="systemPipeR")
targets <- read.delim(targetspath, comment.char = "#")[,1:4]
targets


###################################################
### code chunk number 6: systemPipeVARseq.Rnw:97-102 (eval = FALSE)
###################################################
## args <- systemArgs(sysma="tophat.param", mytargets="targets.txt")
## fqlist <- seeFastq(fastq=infile1(args), batchsize=100000, klength=8)
## pdf("./results/fastqReport.pdf", height=18, width=4*length(fqlist))
## seeFastqPlot(fqlist)
## dev.off()


###################################################
### code chunk number 7: systemPipeVARseq.Rnw:114-116 (eval = FALSE)
###################################################
## args <- systemArgs(sysma="bwa.param", mytargets="targets.txt")
## sysargs(args)[1] # Command-line parameters for first FASTQ file


###################################################
### code chunk number 8: systemPipeVARseq.Rnw:119-124 (eval = FALSE)
###################################################
## moduleload(modules(args))
## system("bwa index -a bwtsw ./data/tair10.fasta")
## resources <- list(walltime="20:00:00", nodes=paste0("1:ppn=", cores(args)), memory="10gb")
## reg <- clusterRun(args, conffile=".BatchJobs.R", template="torque.tmpl", Njobs=18, runid="01", 
##                   resourceList=resources)


###################################################
### code chunk number 9: systemPipeVARseq.Rnw:127-128 (eval = FALSE)
###################################################
## file.exists(outpaths(args))


###################################################
### code chunk number 10: systemPipeVARseq.Rnw:133-135 (eval = FALSE)
###################################################
## read_statsDF <- alignStats(args=args) 
## write.table(read_statsDF, "results/alignStats.xls", row.names=FALSE, quote=FALSE, sep="\t")


###################################################
### code chunk number 11: systemPipeVARseq.Rnw:137-138 (eval = FALSE)
###################################################
## read.delim("results/alignStats.xls")


###################################################
### code chunk number 12: systemPipeVARseq.Rnw:143-146 (eval = FALSE)
###################################################
## symLink2bam(sysargs=args, htmldir=c("~/.html/", "projects/AlexRaikhel/2014/"), 
##             urlbase="http://biocluster.ucr.edu/~tgirke/", 
## 	    urlfile="./results/IGVurl.txt")


###################################################
### code chunk number 13: systemPipeVARseq.Rnw:151-158 (eval = FALSE)
###################################################
## writeTargetsout(x=args, file="targets_bam.txt")
## system("java -jar /opt/picard/1.81/CreateSequenceDictionary.jar R=./data/tair10.fasta O=./data/tair10.dict")
## args <- systemArgs(sysma="gatk.param", mytargets="targets_bam.txt")
## resources <- list(walltime="20:00:00", nodes=paste0("1:ppn=", 1), memory="10gb")
## reg <- clusterRun(args, conffile=".BatchJobs.R", template="torque.tmpl", Njobs=18, runid="01",
##                   resourceList=resources)
## #unlink(outfile1(args), recursive = TRUE, force = TRUE)


###################################################
### code chunk number 14: systemPipeVARseq.Rnw:162-167 (eval = FALSE)
###################################################
## args <- systemArgs(sysma="sambcf.param", mytargets="targets_bam.txt")
## resources <- list(walltime="20:00:00", nodes=paste0("1:ppn=", 1), memory="10gb")
## reg <- clusterRun(args, conffile=".BatchJobs.R", template="torque.tmpl", Njobs=18, runid="01",
##                   resourceList=resources)
## #unlink(outfile1(args), recursive = TRUE, force = TRUE)


###################################################
### code chunk number 15: sessionInfo
###################################################
toLatex(sessionInfo())


