### R code from vignette source 'systemPipeChIPseq.Rnw'

###################################################
### code chunk number 1: style
###################################################
BiocStyle::latex(use.unsrturl=FALSE)


###################################################
### code chunk number 2: systemPipeChIPseq.Rnw:42-44
###################################################
options(width=95)
unlink("test.db")


###################################################
### code chunk number 3: systemPipeChIPseq.Rnw:71-72
###################################################
library(systemPipeR)


###################################################
### code chunk number 4: systemPipeChIPseq.Rnw:76-77 (eval = FALSE)
###################################################
## source("systemPipeChIPseq_Fct.R")


###################################################
### code chunk number 5: systemPipeChIPseq.Rnw:82-85
###################################################
targetspath <- system.file("extdata", "targets.txt", package="systemPipeR")
targets <- read.delim(targetspath, comment.char = "#")[,1:4]
targets


###################################################
### code chunk number 6: systemPipeChIPseq.Rnw:97-102 (eval = FALSE)
###################################################
## args <- systemArgs(sysma="tophat.param", mytargets="targets.txt")
## fqlist <- seeFastq(fastq=infile1(args), batchsize=100000, klength=8)
## pdf("./results/fastqReport.pdf", height=18, width=4*length(fqlist))
## seeFastqPlot(fqlist)
## dev.off()


###################################################
### code chunk number 7: systemPipeChIPseq.Rnw:114-116 (eval = FALSE)
###################################################
## args <- systemArgs(sysma="bowtieSE.param", mytargets="targets.txt")
## sysargs(args)[1] # Command-line parameters for first FASTQ file


###################################################
### code chunk number 8: systemPipeChIPseq.Rnw:119-124 (eval = FALSE)
###################################################
## moduleload(modules(args))
## system("bowtie2-build ./data/aedes-aegypti-liverpool_scaffolds_AaegL3.fa ./data/aedes-aegypti-liverpool_scaffolds_AaegL3.fa")
## resources <- list(walltime="20:00:00", nodes=paste0("1:ppn=", cores(args)), memory="10gb")
## reg <- clusterRun(args, conffile=".BatchJobs.R", template="torque.tmpl", Njobs=18, runid="01", 
##                   resourceList=resources)


###################################################
### code chunk number 9: systemPipeChIPseq.Rnw:127-128 (eval = FALSE)
###################################################
## file.exists(outpaths(args))


###################################################
### code chunk number 10: systemPipeChIPseq.Rnw:133-135 (eval = FALSE)
###################################################
## read_statsDF <- alignStats(args=args) 
## write.table(read_statsDF, "results/alignStats.xls", row.names=FALSE, quote=FALSE, sep="\t")


###################################################
### code chunk number 11: systemPipeChIPseq.Rnw:137-138 (eval = FALSE)
###################################################
## read.delim("results/alignStats.xls")


###################################################
### code chunk number 12: systemPipeChIPseq.Rnw:143-146 (eval = FALSE)
###################################################
## symLink2bam(sysargs=args, htmldir=c("~/.html/", "projects/AlexRaikhel/2014/"), 
##             urlbase="http://biocluster.ucr.edu/~tgirke/", 
## 	    urlfile="./results/IGVurl.txt")


###################################################
### code chunk number 13: sessionInfo
###################################################
toLatex(sessionInfo())


