/*
 * Decompiled with CFR 0.152.
 */
package facs.scale;

import facs.scale.Scale;
import facs.scale.ScaleArgument;

public final class LogScale
implements Scale {
    private static final double changeBase = 1.0 / Math.log(10.0);

    LogScale() {
    }

    public double getValue(double x) {
        return Math.log(x) * changeBase;
    }

    public double getValue(double x, ScaleArgument arg) {
        return this.getValue(x);
    }

    public double unbin(int binIndex, int numBins, double scaleMin, double scaleMax, ScaleArgument arg) {
        double unbinnedValue = 0.0;
        double fractionOfScale = (double)binIndex / (double)numBins;
        double scaleRange = Math.log(scaleMax) * changeBase - Math.log(scaleMin) * changeBase;
        double valueExponent = Math.log(scaleMin) * changeBase + fractionOfScale * scaleRange;
        unbinnedValue = Math.pow(10.0, valueExponent);
        return unbinnedValue;
    }

    public String cacheKey() {
        return "LogScale";
    }
}

